/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common;

import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.application-common.portal-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.application-common.portal-dependencies-configuration.xml")})
public class TestUserHelper
extends BaseCommonsTestCase {
    public void setUp() throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        super.setUp();
        TestUserHelper.assertNotNull((Object)this.container);
        TestUserHelper.assertNotNull((Object)UserHelper.getOrganizationService());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        RequestLifeCycle.end();
    }

    public void testCheckValueUser() throws Exception {
        String values = null;
        TestUserHelper.assertEquals((String)"", (String)UserHelper.checkValueUser(values));
        values = "demo";
        TestUserHelper.assertEquals((String)"", (String)UserHelper.checkValueUser((String)values));
        values = "demo,/platform/users,test";
        TestUserHelper.assertEquals((String)"test", (String)UserHelper.checkValueUser((String)values));
        values = "demo,/platform/users,/platform/test,test";
        TestUserHelper.assertEquals((String)"/platform/test, test", (String)UserHelper.checkValueUser((String)values));
        values = "demo,member:/platform/users,test:/platform/users,test";
        TestUserHelper.assertEquals((String)"test:/platform/users, test", (String)UserHelper.checkValueUser((String)values));
    }

    public void testHasGroupIdAndMembershipId() throws Exception {
        String input = "";
        TestUserHelper.assertFalse((boolean)UserHelper.hasGroupIdAndMembershipId((String)input));
        input = "demo";
        TestUserHelper.assertFalse((boolean)UserHelper.hasGroupIdAndMembershipId((String)input));
        input = "/platform/test";
        TestUserHelper.assertFalse((boolean)UserHelper.hasGroupIdAndMembershipId((String)input));
        input = "test:/platform/users";
        TestUserHelper.assertFalse((boolean)UserHelper.hasGroupIdAndMembershipId((String)input));
        input = "/platform/users";
        TestUserHelper.assertTrue((boolean)UserHelper.hasGroupIdAndMembershipId((String)input));
        input = "member:/platform/users";
        TestUserHelper.assertTrue((boolean)UserHelper.hasGroupIdAndMembershipId((String)input));
    }

    public void testHasUserInGroup() throws Exception {
        TestUserHelper.assertFalse((boolean)UserHelper.hasUserInGroup((String)"groupId", (String)"user"));
        TestUserHelper.assertFalse((boolean)UserHelper.hasUserInGroup((String)"/platform/users", (String)"user"));
        TestUserHelper.assertFalse((boolean)UserHelper.hasUserInGroup((String)"/platform/administrators", (String)"demo"));
        TestUserHelper.assertTrue((boolean)UserHelper.hasUserInGroup((String)"/platform/users", (String)"demo"));
        TestUserHelper.assertTrue((boolean)UserHelper.hasUserInGroup((String)"/platform/administrators", (String)"root"));
    }

    public void testGetDisplayNameOfOwner() throws Exception {
        String owner = null;
        TestUserHelper.assertEquals((String)"", (String)UserHelper.getDisplayNameOfOwner(owner));
        owner = "user";
        TestUserHelper.assertEquals((String)"", (String)UserHelper.getDisplayNameOfOwner((String)owner));
        owner = "demo";
        TestUserHelper.assertEquals((String)"Demo exo", (String)UserHelper.getDisplayNameOfOwner((String)owner));
        owner = "/platform/test";
        TestUserHelper.assertEquals((String)"", (String)UserHelper.getDisplayNameOfOwner((String)owner));
        owner = "/platform/users";
        TestUserHelper.assertEquals((String)"users", (String)UserHelper.getDisplayNameOfOwner((String)owner));
        owner = "test:/platform/users";
        TestUserHelper.assertEquals((String)"", (String)UserHelper.getDisplayNameOfOwner((String)owner));
        owner = "member:/platform/users";
        TestUserHelper.assertEquals((String)"member in users", (String)UserHelper.getDisplayNameOfOwner((String)owner));
    }

    public void testQueryFilter() {
        TestUserHelper.assertEquals((boolean)true, (boolean)true);
        UserHelper.UserFilter filter = new UserHelper.UserFilter("", UserHelper.FilterType.EMAIL);
        Query q = UserHelper.queryFilter((UserHelper.UserFilter)filter);
        TestUserHelper.assertEquals((boolean)true, (boolean)q.isEmpty());
        filter = new UserHelper.UserFilter("email", UserHelper.FilterType.EMAIL);
        q = UserHelper.queryFilter((UserHelper.UserFilter)filter);
        TestUserHelper.assertEquals((String)"*email*", (String)q.getEmail());
        filter = new UserHelper.UserFilter("*email", UserHelper.FilterType.EMAIL);
        q = UserHelper.queryFilter((UserHelper.UserFilter)filter);
        TestUserHelper.assertEquals((String)"*email", (String)q.getEmail());
        filter = new UserHelper.UserFilter("email*", UserHelper.FilterType.EMAIL);
        q = UserHelper.queryFilter((UserHelper.UserFilter)filter);
        TestUserHelper.assertEquals((String)"email*", (String)q.getEmail());
        filter = new UserHelper.UserFilter("*email*", UserHelper.FilterType.EMAIL);
        q = UserHelper.queryFilter((UserHelper.UserFilter)filter);
        TestUserHelper.assertEquals((String)"*email*", (String)q.getEmail());
    }

    public void testMatchUser() {
        MockUser user = null;
        UserHelper.UserFilter userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.USER_NAME);
        TestUserHelper.assertFalse((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, user));
        user = new MockUser("abc", "ABC", "xABcD", "fooAbCbar");
        TestUserHelper.assertTrue((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.FIRST_NAME);
        TestUserHelper.assertTrue((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.LAST_NAME);
        TestUserHelper.assertTrue((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.EMAIL);
        TestUserHelper.assertTrue((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        user = new MockUser("foo", "bar", "xyz", "bool");
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.USER_NAME);
        TestUserHelper.assertFalse((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.FIRST_NAME);
        TestUserHelper.assertFalse((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.LAST_NAME);
        TestUserHelper.assertFalse((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
        userFilter = new UserHelper.UserFilter("abc", UserHelper.FilterType.EMAIL);
        TestUserHelper.assertFalse((boolean)UserHelper.matchUser((UserHelper.UserFilter)userFilter, (User)user));
    }

    private class MockUser
    extends UserImpl {
        public MockUser(String userName, String firstName, String lastName, String email) {
            this.setEmail(email);
            this.setUserName(userName);
            this.setFirstName(firstName);
            this.setLastName(lastName);
        }
    }
}

