/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common;

import junit.framework.TestCase;
import org.exoplatform.forum.common.CommonUtils;

public class TestCommonUtils
extends TestCase {
    public void testIsEmpty() {
        String s = null;
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty(s));
        s = "";
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty((String)s));
        s = " ";
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty((String)s));
        s = "abc";
        TestCommonUtils.assertEquals((boolean)false, (boolean)CommonUtils.isEmpty((String)s));
    }

    public void testIsArrayEmpty() {
        String[] strs = null;
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty(strs));
        strs = new String[]{};
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty((String[])strs));
        strs = new String[]{""};
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty((String[])strs));
        strs = new String[]{" "};
        TestCommonUtils.assertEquals((boolean)true, (boolean)CommonUtils.isEmpty((String[])strs));
        strs = new String[]{"abc"};
        TestCommonUtils.assertEquals((boolean)false, (boolean)CommonUtils.isEmpty((String[])strs));
    }

    public void testRemoveSpecialCharacter() {
        String input = null;
        TestCommonUtils.assertNull((Object)CommonUtils.removeSpecialCharacterForSearch(input));
        input = "";
        TestCommonUtils.assertEquals((String)"", (String)CommonUtils.removeSpecialCharacterForSearch((String)input));
        input = "a  bc ";
        TestCommonUtils.assertEquals((String)"a bc", (String)CommonUtils.removeSpecialCharacterForSearch((String)input));
        input = " a&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_bc    ";
        TestCommonUtils.assertEquals((String)"a ? * % * _bc", (String)CommonUtils.removeSpecialCharacterForSearch((String)input));
    }

    public void testNormalizeUnifiedSearchInput() {
        String input = "";
        TestCommonUtils.assertEquals((String)"", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "normal   text";
        TestCommonUtils.assertEquals((String)"*normal* *text*", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "normal text";
        TestCommonUtils.assertEquals((String)"*normal* *text*", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "normal~0.5 text";
        TestCommonUtils.assertEquals((String)"*normal* *text*", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "normal~0.5 text~0.5 text~1 text~1.0";
        TestCommonUtils.assertEquals((String)"*normal* *text* *text* *text*", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "normal~0.5 text~0.5 text~1 text~1.0 text~text";
        TestCommonUtils.assertEquals((String)"*normal* *text* *text* *text* *texttext*", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "abc z!@#";
        TestCommonUtils.assertEquals((String)"*abc* *z*", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "Japan~1 \u65e5\u672c~1";
        TestCommonUtils.assertEquals((String)"%Japan% %\u65e5\u672c%", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "Vi\u1ec7t~1.0 nam";
        TestCommonUtils.assertEquals((String)"%Vi\u1ec7t% %nam%", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "Russia~0.5 \u0427\u0430\u0441\u0442\u0443\u0448\u043a\u0438";
        TestCommonUtils.assertEquals((String)"%Russia% %\u0427\u0430\u0441\u0442\u0443\u0448\u043a\u0438%", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
        input = "Korea \ud55c\uad6d";
        TestCommonUtils.assertEquals((String)"%Korea% %\ud55c\uad6d%", (String)CommonUtils.normalizeUnifiedSearchInput((String)input));
    }

    public void testHasSpecialCharacter() {
        String input = null;
        TestCommonUtils.assertFalse((boolean)CommonUtils.hasSpecialCharacter(input));
        input = "";
        TestCommonUtils.assertFalse((boolean)CommonUtils.hasSpecialCharacter((String)input));
        input = "abc";
        TestCommonUtils.assertFalse((boolean)CommonUtils.hasSpecialCharacter((String)input));
        input = " AB a X bcS 012 9 ";
        TestCommonUtils.assertFalse((boolean)CommonUtils.hasSpecialCharacter((String)input));
        input = "!@#";
        TestCommonUtils.assertTrue((boolean)CommonUtils.hasSpecialCharacter((String)input));
    }

    public void testProcessSearchCondition() {
        String input = null;
        TestCommonUtils.assertNull((Object)CommonUtils.processSearchCondition(input));
        input = "";
        TestCommonUtils.assertEquals((String)"", (String)CommonUtils.processSearchCondition((String)input));
        input = "abc";
        TestCommonUtils.assertEquals((String)"%abc%", (String)CommonUtils.processSearchCondition((String)input));
        input = " AB a X bcS 012 9 ";
        TestCommonUtils.assertEquals((String)"%AB a X bcS 012 9%", (String)CommonUtils.processSearchCondition((String)input));
        input = " *AB %a X bcS% 012* *a9* ";
        TestCommonUtils.assertEquals((String)"%%AB %a X bcS% 012% %a9%%", (String)CommonUtils.processSearchCondition((String)input));
        input = "  &#<>[]/:\"=.,$()\\+@!^-}{;`~  ";
        TestCommonUtils.assertEquals((String)"%%", (String)CommonUtils.processSearchCondition((String)input));
        input = "  a&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_bc  ";
        TestCommonUtils.assertEquals((String)"%a ? % % % _bc%", (String)CommonUtils.processSearchCondition((String)input));
    }

    public void testGetExcerpt() throws Exception {
        String str = "Revived after the Restoration of 1660. They ended again in 1852, when the common land on which they had been staged was partitioned and enclosed. Since 1966 the Games have been held each year on the Friday after Spring Bank Holiday. Events have included the tug of war, the first stirrings of Britain's Olympic beginnings. (Full article...) excerpt The Cotswold  throwing, fighting with swords, and wrestling. By the time of James's death in 1625, many Puritan landowners had forbidden their workers to attend, and the outbreak of the English Civil War in 1642";
        String expecString = "... and enclosed. Since 1966 the Games have been held each year on the Friday after Spring Bank Holiday. Events have included the tug of war, the first stirrings of Britain's Olympic beginnings. (Full article...) excerpt The Cotswold  throwing, fighting with swords, and wrestling. By the time of James's death in 1625, many Puritan landowners had forbidden their workers to attend, and the outbreak of the English Civil War in ...";
        String truncStr = CommonUtils.getExcerpt((String)str, (String)"excerpt", (int)430);
        TestCommonUtils.assertEquals((String)expecString, (String)truncStr);
        int middlePosition = str.indexOf("excerpt");
        truncStr = CommonUtils.centerTrunc((String)str, (int)middlePosition, (int)430);
        TestCommonUtils.assertEquals((String)expecString, (String)truncStr);
    }

    public void testGetURI() {
        TestCommonUtils.assertNull((Object)CommonUtils.getURI(null));
        TestCommonUtils.assertEquals((String)"", (String)CommonUtils.getURI((String)""));
        TestCommonUtils.assertEquals((String)"/path1/path2/", (String)CommonUtils.getURI((String)"/path1/path2/"));
        TestCommonUtils.assertEquals((String)"http://domain.com", (String)CommonUtils.getURI((String)"http://domain.com"));
        TestCommonUtils.assertEquals((String)"/", (String)CommonUtils.getURI((String)"http://domain.com/"));
        TestCommonUtils.assertEquals((String)"/path1/path2/", (String)CommonUtils.getURI((String)"http://domain.com/path1/path2/"));
        TestCommonUtils.assertEquals((String)"/path1/?q=flower", (String)CommonUtils.getURI((String)"http://domain.com/path1/?q=flower"));
    }
}

