/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.base;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.api.BBCodeService;
import org.exoplatform.forum.bbcode.core.BBCodeServiceImpl;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.SessionManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.bbcode.component.core.test.dependencies-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.bbcode.component.core.test.configuration.xml")})
public abstract class BaseBBcodeTestCase
extends BaseExoTestCase {
    protected BBCodeServiceImpl bbcodeServiceImpl;
    protected BBCodeService bbcodeService;
    protected KSDataLocation locator;
    protected SessionManager sessionManager;
    protected String bbcodesPath;

    public void setUp() throws Exception {
        super.setUp();
        this.begin();
        this.bbcodeServiceImpl = new BBCodeServiceImpl();
        this.locator = this.getService(KSDataLocation.class);
        this.bbcodeService = this.getService(BBCodeService.class);
        this.bbcodeServiceImpl.setDataLocator(this.locator);
        this.sessionManager = this.locator.getSessionManager();
        this.bbcodesPath = this.bbcodeServiceImpl.getDataLocator().getBBCodesLocation();
    }

    public void tearDown() throws Exception {
        for (BBCode bbcode : this.bbcodeService.getAll()) {
            this.bbcodeService.delete(bbcode.getId());
        }
        this.end();
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.getContainer().getComponentInstanceOfType(clazz);
    }

    public BBCode createBBCode(String tag, String replacement, String description, String example, boolean option, boolean active) {
        BBCode bbc = new BBCode();
        bbc.setTagName(tag);
        bbc.setReplacement(replacement);
        bbc.setDescription(description);
        bbc.setExample(example);
        bbc.setOption(option);
        bbc.setActive(active);
        return bbc;
    }

    public boolean nodeExists(String path) {
        boolean isExist = false;
        Node node = this.getNode(path);
        boolean bl = isExist = node != null;
        if (isExist) {
            try {
                node.getSession().logout();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return isExist;
    }

    public void assertNodeExists(String path) {
        BaseBBcodeTestCase.assertTrue((boolean)this.nodeExists(path));
    }

    public void assertNodeNotExists(String path) {
        BaseBBcodeTestCase.assertFalse((boolean)this.nodeExists(path));
    }

    public Node getNode(String path) {
        SessionProvider provider = SessionProvider.createSystemProvider();
        if (path.indexOf("/") == 0) {
            path = path.substring(0);
        }
        Session session = this.sessionManager.getSession(provider);
        try {
            return session.getRootNode().getNode(path);
        }
        catch (Exception e) {
            session.logout();
            return null;
        }
    }

    public void assertContains(List<String> actual, String ... strs) {
        for (int i = 0; i < strs.length; ++i) {
            if (actual.contains(strs[i])) continue;
            BaseBBcodeTestCase.assertTrue((boolean)false);
        }
        BaseBBcodeTestCase.assertTrue((boolean)true);
    }
}

