/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.Collection;
import junit.framework.TestCase;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.api.BBCodeService;
import org.exoplatform.forum.bbcode.core.BBCodeRenderer;
import org.exoplatform.forum.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.forum.bbcode.core.MemoryBBCodeService;
import org.exoplatform.forum.bbcode.spi.BBCodeProvider;

public class TestExtendedBBCodeProvider
extends TestCase {
    private BBCodeRenderer renderer;
    private MemoryBBCodeService bbcodeService;
    private ExtendedBBCodeProvider provider;

    protected void setUp() throws Exception {
        super.setUp();
        this.bbcodeService = new MemoryBBCodeService();
        this.provider = new ExtendedBBCodeProvider();
        this.provider.setBBCodeService((BBCodeService)this.bbcodeService);
        this.renderer = new BBCodeRenderer();
        this.renderer.setBbCodeProvider((BBCodeProvider)this.provider);
    }

    protected void tearDown() throws Exception {
        this.clearAllBBcode();
        super.tearDown();
    }

    public void testGetBBCodes() throws Exception {
        this.registerBBCode("FOO", "");
        TestExtendedBBCodeProvider.assertEquals((String)"FOO", (String)this.provider.getBBCode("FOO").getTagName());
        this.registerOptBBCode("BAR", "");
        BBCode alt = this.provider.getBBCode("BAR=");
        TestExtendedBBCodeProvider.assertNotNull((Object)alt);
        TestExtendedBBCodeProvider.assertTrue((boolean)alt.isOption());
        TestExtendedBBCodeProvider.assertEquals((String)"BAR=", (String)alt.getId());
        TestExtendedBBCodeProvider.assertEquals((String)"BAR", (String)alt.getTagName());
    }

    public void testGetSupportedBBCodes() {
        this.assertEmpty(this.provider.getSupportedBBCodes());
        this.registerBBCode("FOO", "FOO");
        this.registerOptBBCode("FOO", "FOO-OPT");
        this.registerBBCode("BAR", "BAR");
        this.assertContains(this.provider.getSupportedBBCodes(), "FOO", "BAR");
        BBCode code = this.provider.getBBCode("FOO=");
        TestExtendedBBCodeProvider.assertNotNull((Object)code.getTagName());
    }

    private void assertContains(Collection<String> actual, String ... strs) {
        for (int i = 0; i < strs.length; ++i) {
            if (actual.contains(strs[i])) continue;
            TestExtendedBBCodeProvider.assertTrue((boolean)false);
        }
        TestExtendedBBCodeProvider.assertTrue((boolean)true);
    }

    private void assertEmpty(Collection<String> actual) {
        if (actual == null || actual.size() == 0) {
            TestExtendedBBCodeProvider.assertTrue((boolean)true);
        } else {
            TestExtendedBBCodeProvider.assertTrue((boolean)false);
        }
    }

    private void registerBBCode(String tagName, String replacement) {
        BBCode foo = new BBCode();
        foo.setReplacement(replacement);
        foo.setTagName(tagName);
        foo.setActive(true);
        foo.setOption(false);
        this.bbcodeService.addBBCode(foo);
    }

    private void registerOptBBCode(String tagName, String replacement) {
        BBCode foo = new BBCode();
        foo.setReplacement(replacement);
        foo.setTagName(tagName);
        foo.setActive(true);
        foo.setOption(true);
        this.bbcodeService.addBBCode(foo);
    }

    private void clearAllBBcode() throws Exception {
        for (BBCode bbcode : this.bbcodeService.getAll()) {
            this.bbcodeService.delete(bbcode.getId());
        }
    }
}

