/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.utils;

import org.exoplatform.commons.utils.ListAccess;

public abstract class AbstractListAccess<E>
implements ListAccess<E> {
    private int currentPage = 1;
    private int totalPage = 1;
    private int pageSize = 0;
    private int from = 0;
    private int to = 0;
    protected int size = -1;

    public abstract E[] load(int var1) throws Exception, IllegalArgumentException;

    public void reCalculate(int offset, int limit) {
        if (offset >= 0) {
            this.currentPage = offset / limit + 1;
        }
    }

    public void initialize(int pageSize, int pageSelect) throws Exception {
        this.setPageSize(pageSize);
        this.getTotalPages();
        this.setCurrentPage(pageSelect);
    }

    public int getTotalPages() throws Exception {
        this.totalPage = this.getSize() / this.pageSize;
        if (this.getSize() % this.pageSize > 0) {
            ++this.totalPage;
        }
        return this.totalPage;
    }

    public int getPageSize() {
        this.to = this.from + this.pageSize - 1;
        if (this.to > this.size) {
            this.to = this.size - 1;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        this.currentPage = page > this.totalPage && this.totalPage > 0 ? this.totalPage : (page <= 0 ? 1 : page);
    }

    public int getOffset(int page) {
        return (page - 1) * this.pageSize;
    }

    public int getOffset() {
        this.from = this.getOffset(this.currentPage);
        return this.from;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }
}

