/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.poll;

import java.util.HashMap;
import java.util.Random;
import org.exoplatform.forum.extras.injection.poll.AbstractPollInjector;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.Utils;

public class VoteInjector
extends AbstractPollInjector {
    private static final String FROM_POLL = "fromPoll";
    private static final String TO_POLL = "toPoll";
    private static final String POLL_PREFIX = "pollPrefix";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private Random random = new Random();

    public void inject(HashMap<String, String> params) throws Exception {
        int fromPoll = this.getIntParam(params, FROM_POLL);
        int toPoll = this.getIntParam(params, TO_POLL);
        String pollPrefix = params.get(POLL_PREFIX);
        int fromUser = this.getIntParam(params, FROM_USER);
        int toUser = this.getIntParam(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        this.init(null, pollPrefix, null, null, userPrefix);
        for (int i = fromPoll; i < toPoll; ++i) {
            Poll poll = this.getFullPublicPollByName(this.pollPublicBase + String.valueOf(i));
            for (int j = fromUser; j < toUser; ++j) {
                String userName = this.userBase + String.valueOf(j);
                poll = Utils.calculateVote((Poll)poll, (String)userName, (String)this.getRandomVoteOption(poll.getIsMultiCheck()));
                pollService.savePoll(poll, false, true);
            }
        }
    }

    private String getRandomVoteOption(boolean isMultiChoice) {
        StringBuilder builder = new StringBuilder();
        if (isMultiChoice) {
            for (int i = 0; i < this.random.nextInt(4) + 1; ++i) {
                if (builder.length() > 0) {
                    builder.append(":");
                }
                builder.append(this.getVoteValue(builder.toString()));
            }
        } else {
            builder.append(this.random.nextInt(5));
        }
        return builder.toString();
    }

    private String getVoteValue(String str) {
        String s = String.valueOf(this.random.nextInt(5));
        if (str.indexOf(s) >= 0) {
            return this.getVoteValue(str);
        }
        return s;
    }
}

