/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.forum;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.forum.extras.injection.forum.AbstractForumInjector;
import org.exoplatform.forum.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;

public class AttachmentInjector
extends AbstractForumInjector {
    private static final String NUMBER = "number";
    private static final String FROM_POST = "fromPost";
    private static final String TO_POST = "toPost";
    private static final String POST_PREFIX = "postPrefix";
    private static final String BYTE_SIZE = "byteSize";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        String postPrefix = params.get(POST_PREFIX);
        int fromPost = this.param(params, FROM_POST);
        int toPost = this.param(params, TO_POST);
        int byteSize = this.param(params, BYTE_SIZE);
        if (byteSize < 0 || byteSize > 99) {
            this.getLog().info((Object)("ByteSize is invalid with '" + byteSize + "' wrong. Please set it exactly in range 0 - 99 (words). Aborting injection ..."));
            return;
        }
        this.lorem = new LoremIpsum4J();
        this.init(null, null, null, null, postPrefix, byteSize);
        for (int i = fromPost; i <= toPost; ++i) {
            String postName = this.postBase + i;
            Post post = this.getPostByName(postName);
            if (post == null) {
                this.getLog().info((Object)("post name is '" + postName + "' wrong. Please set it exactly. Aborting injection ..."));
                return;
            }
            Topic topic = this.getTopicByPostName(postName);
            Forum forum = this.getForumByTopicName(topic.getTopicName());
            Category cat = this.getCategoryByForumName(forum.getForumName());
            this.generateAttachments(post, POST_PREFIX, number, byteSize);
            this.forumService.savePost(cat.getId(), forum.getId(), topic.getId(), post, false, new MessageBuilder());
            this.getLog().info((Object)("Uploads " + number + " attachments into '" + postName + "' with each attachment's " + byteSize + " byte(s)"));
        }
    }

    private void generateAttachments(Post post, String prefix, int number, int byteSize) throws Exception {
        if (post.getNumberAttach() == 0L) {
            post.setAttachments(new ArrayList());
        }
        int baseNumber = (int)post.getNumberAttach();
        String rs = this.createTextResource(byteSize);
        for (int i = 0; i < number; ++i) {
            String attId = this.generateId(prefix + baseNumber, "attachment", byteSize, i);
            BufferAttachment att = new BufferAttachment();
            att.setId(attId);
            att.setName(attId);
            att.setInputStream((InputStream)new ByteArrayInputStream(rs.getBytes("UTF-8")));
            att.setMimeType("text/plain");
            long fileSize = (long)byteSize * 1024L;
            att.setSize(fileSize);
            post.getAttachments().add(att);
            ++baseNumber;
        }
        post.setNumberAttach((long)baseNumber);
    }

    private String generateId(String prefix, String entity, int byteSize, int order) {
        StringBuilder sb = new StringBuilder();
        sb.append(entity).append("-").append(prefix).append("_").append(this.lorem.getCharacters(byteSize)).append("_").append(order);
        return sb.toString();
    }
}

