/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.faq;

import java.util.HashMap;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.JCRDataStorage;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.extras.injection.utils.ExoNameGenerator;
import org.exoplatform.forum.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;

public abstract class AbstractFAQInjector
extends DataInjector {
    private static Log LOG = ExoLogger.getLogger(AbstractFAQInjector.class);
    private static final String DEFAULT_USER_BASE = "bench.user";
    private static final String DEFAULT_CATEGORY_BASE = "bench.cat";
    private static final String DEFAULT_QUESTION_BASE = "bench.ques";
    private static final String DEFAULT_ANSWER_BASE = "bench.answer";
    private static final String DEFAULT_COMMENT_BASE = "bench.comment";
    private static final int DEFAULT_BYTE_SIZE_BASE = 100;
    protected static final String PASSWORD = "exo";
    protected static final String DOMAIN = "exoplatform.int";
    protected String userBase;
    protected String categoryBase;
    protected String questionBase;
    protected String answerBase;
    protected String commentBase;
    protected int byteSizeBase;
    protected final OrganizationService organizationService;
    protected final FAQService faqService;
    protected final KSDataLocation locator;
    protected final UserHandler userHandler;
    protected FAQSetting faqSetting;
    protected int userNumber;
    protected int categoryNumber;
    protected int questionNumber;
    protected int answerNumber;
    protected int commentNumber;
    protected final Random random;
    protected ExoNameGenerator exoNameGenerator;
    protected LoremIpsum4J lorem;
    private Category categoryRoot;

    public AbstractFAQInjector() {
        PortalContainer c = PortalContainer.getInstance();
        this.faqService = (FAQService)c.getComponentInstanceOfType(FAQService.class);
        this.organizationService = (OrganizationService)c.getComponentInstanceOfType(OrganizationService.class);
        this.locator = (KSDataLocation)c.getComponentInstanceOfType(KSDataLocation.class);
        this.userHandler = this.organizationService.getUserHandler();
        this.exoNameGenerator = new ExoNameGenerator();
        this.random = new Random();
        this.lorem = new LoremIpsum4J();
        this.faqSetting = new FAQSetting();
        this.faqSetting.setDisplayMode("");
        this.faqSetting.setEmailSettingSubject("eXo Answers Notification");
        this.faqSetting.setEmailSettingContent("<p>We have a new question or answer by injector datas in category <strong>&categoryName_</strong></p><p><em>&questionContent_</em></p>");
    }

    public void init(String userPrefix, String categoryPrefix, String questionPrefix, String answerPrefix, String commentPrefix, int byteSize) {
        this.userBase = userPrefix == null ? DEFAULT_USER_BASE : userPrefix;
        this.categoryBase = categoryPrefix == null ? DEFAULT_CATEGORY_BASE : categoryPrefix;
        this.questionBase = questionPrefix == null ? DEFAULT_QUESTION_BASE : questionPrefix;
        this.answerBase = answerPrefix == null ? DEFAULT_ANSWER_BASE : answerPrefix;
        this.commentBase = commentPrefix == null ? DEFAULT_COMMENT_BASE : commentPrefix;
        this.byteSizeBase = byteSize == 0 ? 100 : byteSize;
        this.categoryNumber = 0;
        this.questionNumber = 0;
        this.answerNumber = 0;
        this.commentNumber = 0;
        try {
            this.userNumber = this.userNumber(this.userBase);
            this.categoryNumber = this.categoryNumber(this.categoryBase);
            this.questionNumber = this.questionNumber(this.questionBase);
            this.answerNumber = this.answerNumber(this.answerBase);
            this.commentNumber = this.commentNumber(this.commentBase);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when initilizing data.", (Throwable)e);
        }
        LOG.info((Object)("Initial user number : " + this.userNumber));
        LOG.info((Object)("Initial category number : " + this.categoryNumber));
        LOG.info((Object)("Initial question number : " + this.questionNumber));
        LOG.info((Object)("Initial answer number : " + this.answerNumber));
        LOG.info((Object)("Initial comment number : " + this.commentNumber));
    }

    public int userNumber(String base) throws Exception {
        org.exoplatform.services.organization.Query query = new org.exoplatform.services.organization.Query();
        query.setUserName(base + "*");
        return this.userHandler.findUsersByQuery(query).getSize();
    }

    public int categoryNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:faqCategory").append(")[jcr:like(exo:name, '%").append(base).append("%')]");
        return (int)this.search(sb.toString()).getSize();
    }

    public int questionNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:faqQuestion").append(")[jcr:like(exo:title, '%").append(base).append("%')]");
        return (int)this.search(sb.toString()).getSize();
    }

    public int answerNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:answer").append(")[jcr:like(exo:fullName, '%").append(base).append("%')]");
        return (int)this.search(sb.toString()).getSize();
    }

    public int commentNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:comment").append(")[jcr:like(exo:fullName, '%").append(base).append("%')]");
        return (int)this.search(sb.toString()).getSize();
    }

    protected Category getCategoryRoot(boolean isUpdate) {
        try {
            if (isUpdate || this.categoryRoot == null) {
                this.categoryRoot = this.faqService.getCategoryById("categories");
            }
            return this.categoryRoot;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected NodeIterator search(String queryString) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            QueryManager qm = this.getFAQHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            return result.getNodes();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to search", (Throwable)e);
            return null;
        }
    }

    protected Node getFAQHomeNode(SessionProvider sProvider) throws Exception {
        String path = this.locator.getForumHomeLocation();
        return this.locator.getSessionManager().getSession(sProvider).getRootNode().getNode(path);
    }

    public Category getCategoryByName(String catName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:faqCategory").append(")[jcr:like(exo:name, '%").append(catName).append("%')]");
        NodeIterator iterator = this.search(sb.toString());
        if (iterator.hasNext()) {
            Node cateNode = (Node)iterator.next();
            PropertyReader reader = new PropertyReader(cateNode);
            Category cat = new Category();
            cat.setName(cateNode.getName());
            cat.setPath(cateNode.getPath());
            cat.setCreatedDate(reader.date("exo:createdDate"));
            cat.setDescription(reader.string("exo:description"));
            cat.setId(reader.string("exo:id"));
            cat.setIndex(reader.l("exo:index"));
            cat.setModerators(reader.strings("exo:moderators"));
            cat.setUserPrivate(reader.strings("exo:userPrivate"));
            cat.setViewAuthorInfor(reader.bool("exo:viewAuthorInfor").booleanValue());
            return cat;
        }
        return null;
    }

    public Question getQuestionByName(String questionName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:faqQuestion").append(")[jcr:like(exo:title, '%").append(questionName).append("%')]");
        NodeIterator iterator = this.search(sb.toString());
        if (iterator.hasNext()) {
            Node quesNode = (Node)iterator.next();
            String quesNodePath = quesNode.getPath();
            Question question = new Question();
            PropertyReader reader = new PropertyReader(quesNode);
            question.setAttachMent(JCRDataStorage.getFileAttachments((Node)quesNode));
            question.setAuthor(reader.string("exo:author"));
            question.setCategoryId(reader.string("exo:categoryId"));
            question.setCategoryPath(quesNodePath.substring(quesNodePath.indexOf("categories"), quesNodePath.indexOf(Utils.QUESTION_HOME) - 1));
            question.setEmail(reader.string("exo:email"));
            question.setEmailsWatch(reader.strings("exo:emailWatching"));
            question.setId(reader.string("exo:id"));
            question.setLanguage(reader.string("exo:language"));
            question.setLink(reader.string("exo:link"));
            question.setMarkVote(reader.d("exo:markVote").doubleValue());
            question.setQuestion(questionName);
            question.setPath(quesNodePath.substring(quesNodePath.indexOf("categories")));
            question.setTopicIdDiscuss(reader.string("exo:topicIdDiscuss"));
            question.setUsersVote(reader.strings("exo:usersVote"));
            return question;
        }
        return null;
    }

    public Answer getAnswerByName(String answerName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:answer").append(")[jcr:like(exo:fullName, '%").append(answerName).append("%')]");
        NodeIterator iterator = this.search(sb.toString());
        if (iterator.hasNext()) {
            Node answerNode = (Node)iterator.next();
            Answer answer = new Answer();
            answer.setPath(answerNode.getPath());
            PropertyReader reader = new PropertyReader(answerNode);
            answer.setDateResponse(reader.date("exo:dateResponse"));
            answer.setId(reader.string("exo:id"));
            answer.setLanguage(reader.string("exo:language"));
            answer.setUsersVoteAnswer(reader.strings("exo:usersVoteAnswer"));
            return answer;
        }
        return null;
    }

    public Comment getCommentByName(String commentName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getFaqCategoriesLocation()).append("//element(*,");
        sb.append("exo:comment").append(")[jcr:like(exo:fullName, '%").append(commentName).append("%')]");
        NodeIterator iterator = this.search(sb.toString());
        if (iterator.hasNext()) {
            Node commentNode = (Node)iterator.next();
            Comment comment = new Comment();
            PropertyReader reader = new PropertyReader(commentNode);
            comment.setDateComment(reader.date("exo:dateComment"));
            comment.setId(reader.string("exo:id"));
            return comment;
        }
        return null;
    }

    protected String userName() {
        return this.userBase + this.userNumber;
    }

    protected String categoryName() {
        return this.categoryBase + this.categoryNumber;
    }

    protected String questionName() {
        return this.questionBase + this.questionNumber;
    }

    protected String answerName() {
        return this.answerBase + this.answerNumber;
    }

    protected String commentName() {
        return this.commentBase + this.commentNumber;
    }

    public Object execute(HashMap<String, String> stringStringHashMap) throws Exception {
        return null;
    }

    public void reject(HashMap<String, String> stringStringHashMap) throws Exception {
    }

    public Log getLog() {
        return ExoLogger.getExoLogger(((Object)((Object)this)).getClass());
    }

    protected int param(HashMap<String, String> params, String name) {
        if (params == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String value = params.get(name);
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + name));
        }
        return 0;
    }
}

