/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.faq;

import java.util.HashMap;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.extras.injection.faq.AbstractFAQInjector;

public class CommentInjector
extends AbstractFAQInjector {
    private static final String NUMBER = "number";
    private static final String TO_QUES = "toQues";
    private static final String QUESTION_PREFIX = "quesPrefix";
    private static final String COMMENT_PREFIX = "commentPrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int toQues = this.param(params, TO_QUES);
        String questionPrefix = params.get(QUESTION_PREFIX);
        String commentPrefix = params.get(COMMENT_PREFIX);
        this.init(null, null, questionPrefix, null, commentPrefix, 0);
        String questionName = this.questionBase + toQues;
        Question question = this.getQuestionByName(questionName);
        if (question == null) {
            this.getLog().info((Object)("Question name '" + questionName + "' is wrong. Aborting injection ..."));
            return;
        }
        String commentName = null;
        Comment comment = null;
        for (int i = 0; i < number; ++i) {
            commentName = this.commentName();
            comment = new Comment();
            comment.setCommentBy(question.getAuthor());
            comment.setComments(this.lorem.getParagraphs(1));
            comment.setFullName(commentName);
            comment.setNew(true);
            comment.setPostId("");
            this.faqService.saveComment(question.getPath(), comment, true);
            ++this.commentNumber;
            this.getLog().info((Object)("Comment '" + commentName + "' created by " + question.getAuthor()));
        }
    }
}

