/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.forum;

import java.util.Date;
import java.util.HashMap;
import org.exoplatform.forum.extras.injection.forum.AbstractForumInjector;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;

public class ForumInjector
extends AbstractForumInjector {
    private static final String NUMBER = "number";
    private static final String TO_CAT = "toCat";
    private static final String FORUM_PREFIX = "forumPrefix";
    private static final String CATEGORY_PREFIX = "catPrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int to = this.param(params, TO_CAT);
        String forumPrefix = params.get(FORUM_PREFIX);
        String categoryPrefix = params.get(CATEGORY_PREFIX);
        this.init(null, categoryPrefix, forumPrefix, null, null, 0);
        String categoryName = this.categoryBase + to;
        Category cat = this.getCategoryByName(categoryName);
        if (cat == null) {
            this.getLog().info((Object)("category name is '" + categoryName + "' is wrong. Please set it exactly. Aborting injection ..."));
            return;
        }
        for (int j = 0; j < number; ++j) {
            String forumName = this.forumName();
            Forum forum = new Forum();
            forum.setOwner(cat.getOwner());
            forum.setForumName(forumName);
            forum.setForumOrder(1);
            forum.setCreatedDate(new Date());
            forum.setModifiedBy(cat.getOwner());
            forum.setModifiedDate(new Date());
            forum.setLastTopicPath("");
            forum.setDescription(forumName + " description");
            forum.setPostCount(0L);
            forum.setTopicCount(0L);
            forum.setNotifyWhenAddTopic(new String[0]);
            forum.setNotifyWhenAddPost(new String[0]);
            forum.setIsModeratePost(false);
            forum.setIsModerateTopic(false);
            forum.setIsClosed(false);
            forum.setIsLock(false);
            forum.setViewer(new String[0]);
            forum.setCreateTopicRole(new String[0]);
            forum.setModerators(new String[0]);
            this.forumService.saveForum(cat.getId(), forum, true);
            ++this.forumNumber;
            this.getLog().info((Object)("Forum '" + forumName + "' for catefgory '" + categoryName + "' created by " + cat.getOwner()));
        }
    }
}

