/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.forum;

import java.util.Date;
import java.util.HashMap;
import org.exoplatform.forum.extras.injection.forum.AbstractForumInjector;
import org.exoplatform.forum.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;

public class PostInjector
extends AbstractForumInjector {
    private static final String NUMBER = "number";
    private static final String POST_PREFIX = "postPrefix";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private static final String TO_TOPIC = "toTopic";
    private static final String TOPIC_PREFIX = "topicPrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        String postPrefix = params.get(POST_PREFIX);
        int fromUser = this.param(params, FROM_USER);
        int toUser = this.param(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        int toTopic = this.param(params, TO_TOPIC);
        String topicPrefix = params.get(TOPIC_PREFIX);
        this.init(userPrefix, null, null, topicPrefix, postPrefix, 0);
        String topicName = this.topicBase + toTopic;
        Topic topic = this.getTopicByName(topicName);
        if (topic == null) {
            this.getLog().info((Object)("topic name is '" + topicName + "' wrong. Please set it exactly. Aborting injection ..."));
            return;
        }
        Forum forum = this.getForumByTopicName(topicName);
        Category cat = this.getCategoryByForumName(forum.getForumName());
        for (int i = fromUser; i <= toUser; ++i) {
            String owner = this.userBase + i;
            for (int j = 0; j < number; ++j) {
                this.lorem = new LoremIpsum4J();
                String postName = this.postName();
                Post post = new Post();
                post.setOwner(owner);
                post.setCreatedDate(new Date());
                post.setModifiedBy(owner);
                post.setModifiedDate(new Date());
                post.setName(postName);
                post.setMessage(this.lorem.getParagraphs());
                post.setRemoteAddr("127.0.0.1");
                post.setIcon("classNameIcon");
                post.setIsApproved(true);
                post.setIsActiveByTopic(true);
                post.setIsHidden(false);
                post.setIsWaiting(false);
                this.forumService.savePost(cat.getId(), forum.getId(), topic.getId(), post, true, new MessageBuilder());
                ++this.postNumber;
                this.getLog().info((Object)("Post '" + postName + "' into '" + topicName + "' topic of '" + forum.getForumName() + "' forum created by " + owner));
            }
        }
    }
}

