/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.forum;

import java.util.Arrays;
import java.util.HashMap;
import org.exoplatform.forum.extras.injection.forum.AbstractForumInjector;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Topic;

public class MembershipInjector
extends AbstractForumInjector {
    private static final String TYPE = "type";
    private static final String TO_TYPE = "toType";
    private static final String TYPE_PREFIX = "typePrefix";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private int toType;
    private String typePrefix;
    private int fromUser;
    private int toUser;
    private String userPrefix;

    public void inject(HashMap<String, String> params) throws Exception {
        String type = params.get(TYPE);
        if (type == null | type.length() <= 0) {
            this.getLog().info((Object)"type value is wrong! Please set it exactly with 'category', 'forum', or 'topic' value. Aborting injection ...");
            return;
        }
        this.toType = this.param(params, TO_TYPE);
        this.typePrefix = params.get(TYPE_PREFIX);
        this.fromUser = this.param(params, FROM_USER);
        this.toUser = this.param(params, TO_USER);
        this.userPrefix = params.get(USER_PREFIX);
        if ("category".equals(type)) {
            this.init(this.userPrefix, this.typePrefix, null, null, null, 0);
            this.injectCategory();
        } else if ("forum".equals(type)) {
            this.init(this.userPrefix, null, this.typePrefix, null, null, 0);
            this.injectForum();
        } else if ("topic".equals(type)) {
            this.init(this.userPrefix, null, null, this.typePrefix, null, 0);
            this.injectTopic();
        } else {
            this.getLog().info((Object)"type value is wrong! Please set it exactly with 'category', 'forum', or'topic'. Aborting injection ...");
            return;
        }
    }

    private void injectCategory() throws Exception {
        String categoryName = this.categoryBase + this.toType;
        Category cat = this.getCategoryByName(categoryName);
        if (cat == null) {
            this.getLog().info((Object)("category name is '" + categoryName + "' is wrong. Please set it exactly. Aborting injection ..."));
            return;
        }
        Object[] userNames = this.getUserNames();
        if (userNames == null | userNames.length <= 0) {
            this.getLog().info((Object)("Don't assign permission any user to '" + categoryName + "' forum. Please set it exactly. Aborting injection ..."));
            return;
        }
        cat = this.forumService.getCategory(cat.getId());
        cat.setModerators((String[])userNames);
        cat.setCreateTopicRole((String[])userNames);
        cat.setViewer((String[])userNames);
        cat.setPoster((String[])userNames);
        this.forumService.saveCategory(cat, false);
        this.getLog().info((Object)("Assign permission '" + Arrays.toString(userNames) + "' user(s) into '" + categoryName + "' category."));
    }

    private void injectForum() throws Exception {
        String forumName = this.forumBase + this.toType;
        Forum forum = this.getForumByName(forumName);
        if (forum == null) {
            this.getLog().info((Object)("forum name is '" + forumName + "' is wrong. Please set it exactly. Aborting injection ..."));
            return;
        }
        Category cat = this.getCategoryByForumName(forumName);
        Object[] userNames = this.getUserNames();
        if (userNames == null | userNames.length <= 0) {
            this.getLog().info((Object)("Don't assign permission any user to '" + forumName + "' forum. Please set it exactly. Aborting injection ..."));
            return;
        }
        forum = this.forumService.getForum(cat.getId(), forum.getId());
        forum.setModerators((String[])userNames);
        forum.setCreateTopicRole((String[])userNames);
        forum.setViewer((String[])userNames);
        forum.setPoster((String[])userNames);
        this.forumService.saveForum(cat.getId(), forum, false);
        this.getLog().info((Object)("Assign permission '" + Arrays.toString(userNames) + "' user(s) into '" + forumName + "' forum in '" + cat.getCategoryName() + "' category."));
    }

    private void injectTopic() throws Exception {
        String topicName = this.topicBase + this.toType;
        Topic topic = this.getTopicByName(topicName);
        if (topic == null) {
            this.getLog().info((Object)("topic name is '" + topicName + "' is wrong. Please set it exactly. Aborting injection ..."));
            return;
        }
        Forum forum = this.getForumByTopicName(topicName);
        Category cat = this.getCategoryByForumName(forum.getForumName());
        Object[] userNames = this.getUserNames();
        if (userNames == null | userNames.length <= 0) {
            this.getLog().info((Object)("Don't assign permission any user to '" + topicName + "' topic. Please set it exactly. Aborting injection ..."));
            return;
        }
        topic = this.forumService.getTopic(cat.getId(), forum.getId(), topic.getId(), null);
        topic.setCanPost((String[])userNames);
        topic.setCanView((String[])userNames);
        topic.setEmailNotification((String[])userNames);
        this.forumService.saveTopic(cat.getId(), forum.getId(), topic, false, false, new MessageBuilder());
        this.getLog().info((Object)("Assign permission '" + Arrays.toString(userNames) + "' user(s) into '" + topicName + "' topic in '" + forum.getForumName() + "' forum."));
    }

    private String[] getUserNames() throws Exception {
        String[] result = new String[this.toUser - this.fromUser + 1];
        int userIdx = 0;
        for (int i = this.fromUser; i <= this.toUser; ++i) {
            String username = this.userBase + i;
            if (this.userHandler.findUserByName(username) == null) continue;
            result[userIdx] = username;
            ++userIdx;
        }
        return result;
    }
}

