/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.forum;

import java.util.Date;
import java.util.HashMap;
import org.exoplatform.forum.extras.injection.forum.AbstractForumInjector;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Topic;

public class TopicInjector
extends AbstractForumInjector {
    private static final String NUMBER = "number";
    private static final String TOPIC_PREFIX = "topicPrefix";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private static final String TO_FORUM = "toForum";
    private static final String FORUM_PREFIX = "forumPrefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        String topicPrefix = params.get(TOPIC_PREFIX);
        int fromUser = this.param(params, FROM_USER);
        int toUser = this.param(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        int toForum = this.param(params, TO_FORUM);
        String forumPrefix = params.get(FORUM_PREFIX);
        this.init(userPrefix, null, forumPrefix, topicPrefix, null, 0);
        String forumName = this.forumBase + toForum;
        Forum forum = this.getForumByName(forumName);
        if (forum == null) {
            this.getLog().info((Object)("forum name is '" + forumName + "' wrong. Please set it exactly. Aborting injection ..."));
            return;
        }
        Category cat = this.getCategoryByForumName(forumName);
        for (int i = fromUser; i <= toUser; ++i) {
            String owner = this.userBase + i;
            for (int j = 0; j < number; ++j) {
                String topicName = this.topicName();
                Topic topicNew = new Topic();
                topicNew.setOwner(owner);
                topicNew.setTopicName(topicName);
                topicNew.setCreatedDate(new Date());
                topicNew.setModifiedBy(owner);
                topicNew.setModifiedDate(new Date());
                topicNew.setLastPostBy(owner);
                topicNew.setLastPostDate(new Date());
                topicNew.setDescription(this.lorem.getParagraphs());
                topicNew.setPostCount(0L);
                topicNew.setViewCount(0L);
                topicNew.setIsNotifyWhenAddPost("");
                topicNew.setIsModeratePost(false);
                topicNew.setIsClosed(false);
                topicNew.setIsLock(false);
                topicNew.setIsWaiting(false);
                topicNew.setIsActive(true);
                topicNew.setIcon("classNameIcon");
                topicNew.setIsApproved(true);
                topicNew.setCanView(new String[0]);
                topicNew.setCanPost(new String[0]);
                this.forumService.saveTopic(cat.getId(), forum.getId(), topicNew, true, false, new MessageBuilder());
                ++this.topicNumber;
                this.getLog().info((Object)("Topic '" + topicName + "' in forum '" + forumName + "' created by " + owner));
            }
        }
    }
}

