/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.poll;

import java.util.HashMap;
import java.util.Random;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.extras.injection.poll.AbstractPollInjector;
import org.exoplatform.forum.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.service.Utils;

public class PollInjector
extends AbstractPollInjector {
    private static final String PARENT_PATH_GROUP = "/" + PollNodeTypes.APPLICATION_DATA + "/" + PollNodeTypes.EXO_POLLS;
    private static final String POLL_PREFIX = "pollPrefix";
    private static final String POLL_TYPE = "pollType";
    private static final String GROUP_PREFIX = "groupPrefix";
    private static final String NUMBER = "number";
    private static final String TO_GROUP = "toGroup";
    private boolean isPublic = true;
    private LoremIpsum4J ipsum4j = new LoremIpsum4J();

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.getIntParam(params, NUMBER);
        String pollType = params.get(POLL_TYPE);
        String pollPrefix = params.get(POLL_PREFIX);
        String groupPrefix = params.get(GROUP_PREFIX);
        String toGroup = params.get(TO_GROUP);
        this.isPublic = "public".equals(pollType);
        if (this.isPublic) {
            this.init(null, pollPrefix, null, null, null);
            String parentPath = ExoContainerContext.getCurrentContainer().getContext().getName();
            if (Utils.isEmpty((String)parentPath)) {
                parentPath = "portal";
            }
            parentPath = parentPath + "/" + PollNodeTypes.POLLS;
            this.injectPoll("", parentPath, number);
        } else {
            if (Utils.isEmpty((String)toGroup)) {
                this.getLog().info((Object)"Private poll: groupPrefix or toGroup value is wrong! Please set it exactly with 'groupPrefix' or 'toGroup' value. Aborting injection ...");
                return;
            }
            this.init(groupPrefix, null, pollPrefix, toGroup, null);
            String injectToGroupName = this.groupBase + toGroup;
            String parentPath = injectToGroupName + PARENT_PATH_GROUP;
            this.injectPoll(injectToGroupName, parentPath, number);
        }
    }

    private void injectPoll(String toGroupName, String parentPath, int number) throws Exception {
        String[] options = this.createOption(5);
        String[] votes = new String[]{"0.0", "0.0", "0.0", "0.0", "0.0"};
        for (int i = 0; i < number; ++i) {
            Poll poll = new Poll();
            poll.setParentPath(parentPath);
            poll.setQuestion(this.isPublic ? this.pollPublicName() : this.pollPrivateName());
            poll.setOption(options);
            poll.setVote(votes);
            poll.setOwner("root");
            poll.setIsMultiCheck(new Random().nextBoolean());
            pollService.savePoll(poll, true, false);
            if (this.isPublic) {
                this.getLog().info((Object)("Public poll '" + poll.getQuestion() + "' generated."));
            } else {
                this.getLog().info((Object)("Private poll '" + poll.getQuestion() + "' generated into '" + toGroupName + "' group"));
            }
            if (this.isPublic) {
                ++this.pollPublicNumber;
                continue;
            }
            ++this.pollPrivateNumber;
        }
    }

    private String[] createOption(int size) {
        String[] options = new String[size];
        for (int i = 0; i < size; ++i) {
            options[i] = (this.isPublic ? this.pollPublicName() : this.pollPrivateName()) + "_option" + (i + 1) + " " + this.ipsum4j.getWords(10);
        }
        return options;
    }
}

