/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.poll;

import java.util.HashMap;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.extras.injection.utils.ExoNameGenerator;
import org.exoplatform.forum.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;

public abstract class AbstractPollInjector
extends DataInjector {
    public static final String POLL_DEFAULT_TYPE = "public";
    public static final String DEFAULT_POLL_PRIVATE_PREFIX = "private.poll";
    public static final String DEFAULT_POLL_PUBLIC_PREFIX = "public.poll";
    public static final String DEFAULT_GROUP_PREFIX = "bench.group";
    private static final String DEFAULT_USER_BASE = "bench.user";
    protected static final int OPTION_DEFAULT_SIZE = 5;
    protected static PollService pollService;
    protected static ForumService forumService;
    protected final KSDataLocation locator;
    protected static OrganizationService organizationService;
    protected GroupHandler groupHandler;
    protected String groupBase;
    protected int groupNumber = 0;
    protected String pollPublicBase;
    protected String pollPrivateBase;
    protected int pollPrivateNumber;
    protected int pollPublicNumber;
    protected String optionBase;
    protected int optionNumber;
    protected String userBase;
    protected int userNumber;
    protected Random random = new Random();
    protected ExoNameGenerator exoNameGenerator = new ExoNameGenerator();
    protected LoremIpsum4J lorem = new LoremIpsum4J();
    private static final Log LOG;
    public static final String POLL_TYPE = "type";

    public AbstractPollInjector() {
        PortalContainer container = PortalContainer.getInstance();
        pollService = (PollService)container.getComponentInstance(PollService.class);
        forumService = (ForumService)container.getComponentInstance(ForumService.class);
        this.locator = (KSDataLocation)container.getComponentInstance(KSDataLocation.class);
        organizationService = (OrganizationService)container.getComponentInstance(OrganizationService.class);
        this.groupHandler = organizationService.getGroupHandler();
    }

    public Log getLog() {
        return ExoLogger.getExoLogger(((Object)((Object)this)).getClass());
    }

    public Object execute(HashMap<String, String> stringHashMap) throws Exception {
        return null;
    }

    public void reject(HashMap<String, String> stringHashMap) throws Exception {
    }

    protected String pollPublicName() {
        return this.pollPublicBase + this.pollPublicNumber;
    }

    protected String pollPrivateName() {
        return this.pollPrivateBase + this.pollPrivateNumber;
    }

    protected String groupName() {
        return this.groupBase + this.groupNumber;
    }

    public void init(String groupPrefix, String pollPublicPrefix, String pollPrivatePrefix, String toGroup, String userPrefix) {
        this.groupBase = groupPrefix == null ? DEFAULT_GROUP_PREFIX : groupPrefix;
        this.pollPrivateBase = pollPrivatePrefix == null ? DEFAULT_POLL_PRIVATE_PREFIX : pollPrivatePrefix;
        this.pollPublicBase = pollPublicPrefix == null ? DEFAULT_POLL_PUBLIC_PREFIX : pollPublicPrefix;
        this.userBase = userPrefix == null ? DEFAULT_USER_BASE : userPrefix;
        try {
            this.groupNumber = this.groupNumber(this.groupBase);
            this.pollPrivateNumber = this.pollNumberForPrivate(this.groupBase + (toGroup == null ? "" : toGroup), this.pollPrivateBase);
            this.pollPublicNumber = this.pollNumberForPublic(this.pollPublicBase);
            this.userNumber = this.userNumber(this.userBase);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when initilizing data.", (Throwable)e);
        }
        LOG.info((Object)("Initial user number : " + this.userNumber));
        LOG.info((Object)("Initial group number : " + this.groupNumber));
        LOG.info((Object)("Initial poll private number : " + this.pollPrivateNumber));
        LOG.info((Object)("Initial poll public number : " + this.pollPublicNumber));
    }

    public int groupNumber(String base) throws Exception {
        int count = 0;
        for (Object gr : this.groupHandler.findGroups(null)) {
            if (!((Group)gr).getGroupName().contains(base)) continue;
            ++count;
        }
        return count;
    }

    public Group getGroupByName(String groupName) throws Exception {
        return this.groupHandler.findGroupById("/" + groupName);
    }

    public int userNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getUserProfilesLocation()).append("/element(*,");
        sb.append(Utils.USER_PROFILES_TYPE).append(")[jcr:like(exo:userId, '%").append(base).append("%')]");
        return (int)forumService.search(sb.toString()).getSize();
    }

    public Poll getPublicPollByName(String pollName) throws Exception {
        return this.getPoll(this.getPublicPollNodeByName(pollName));
    }

    public Poll getFullPublicPollByName(String pollName) throws Exception {
        return this.getPollNode(this.getPublicPollNodeByName(pollName));
    }

    public Node getPublicPollNodeByName(String pollName) throws Exception {
        try {
            StringBuffer sb = new StringBuffer("/jcr:root");
            String rootPath = "exo:applications";
            sb.append("/").append(rootPath).append("//element(*,").append("exo:poll").append(")");
            sb.append("[(@exo:question='").append(pollName).append("')]");
            NodeIterator it = forumService.search(sb.toString());
            if (it.hasNext()) {
                return it.nextNode();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get public Poll node by name.", (Throwable)e);
        }
        return null;
    }

    private Poll getPollNode(Node pollNode) throws Exception {
        if (pollNode == null) {
            return null;
        }
        Poll pollNew = new Poll();
        pollNew.setId(pollNode.getName());
        pollNew.setParentPath(pollNode.getParent().getPath());
        PropertyReader reader = new PropertyReader(pollNode);
        pollNew.setOwner(reader.string("exo:owner"));
        pollNew.setModifiedBy(reader.string("exo:modifiedBy"));
        pollNew.setCreatedDate(reader.date("exo:createdDate"));
        pollNew.setModifiedDate(reader.date("exo:modifiedDate"));
        pollNew.setLastVote(reader.date("exo:lastVote"));
        pollNew.setTimeOut(reader.l("exo:timeOut", 0L));
        pollNew.setQuestion(reader.string("exo:question"));
        pollNew.setOption(reader.strings("exo:option", new String[0]));
        pollNew.setVote(reader.strings("exo:vote", new String[0]));
        pollNew.setUserVote(reader.strings("exo:userVote", new String[0]));
        pollNew.setIsMultiCheck(reader.bool("exo:isMultiCheck").booleanValue());
        pollNew.setIsAgainVote(reader.bool("exo:isAgainVote", false).booleanValue());
        pollNew.setIsClosed(reader.bool("exo:isClosed", false).booleanValue());
        return pollNew;
    }

    private Poll getPoll(Node pollNode) throws Exception {
        if (pollNode == null) {
            return null;
        }
        Poll pollNew = new Poll();
        pollNew.setId(pollNode.getName());
        pollNew.setParentPath(pollNode.getParent().getPath());
        return pollNew;
    }

    public Poll getPrivatePollByName(String groupName, String pollName) throws Exception {
        try {
            StringBuffer sb = new StringBuffer("/jcr:root");
            String rootPath = PollNodeTypes.GROUPS + "/" + groupName;
            sb.append("/").append(rootPath).append("//element(*,").append("exo:poll").append(")");
            sb.append("[(@exo:question='").append(pollName).append("')]");
            NodeIterator it = forumService.search(sb.toString());
            if (it.hasNext()) {
                return this.getPoll(it.nextNode());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get private Poll node by name.", (Throwable)e);
        }
        return null;
    }

    public int pollNumberForPrivate(String groupName, String pollBase) throws Exception {
        try {
            StringBuffer sb = new StringBuffer("/jcr:root");
            String rootPath = PollNodeTypes.GROUPS + "/" + groupName;
            sb.append("/").append(rootPath).append("//element(*,");
            sb.append("exo:poll").append(")[jcr:like(exo:question, '%").append(pollBase).append("%')]");
            return (int)forumService.search(sb.toString()).getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int pollNumberForPublic(String pollBase) throws Exception {
        try {
            return (int)this.pollNodesForPublic(pollBase).getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public NodeIterator pollNodesForPublic(String pollBase) throws Exception {
        try {
            StringBuffer sb = new StringBuffer("/jcr:root");
            String rootPath = "exo:applications";
            sb.append("/").append(rootPath).append("//element(*,");
            sb.append("exo:poll").append(")[jcr:like(exo:question, '%").append(pollBase).append("%')]");
            return forumService.search(sb.toString());
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to find Poll nodes for public.", (Throwable)e);
            return null;
        }
    }

    protected static String getStringValueParam(HashMap<String, String> params, String key, String defaultValue) {
        if (params == null) {
            throw new NullPointerException();
        }
        String vl = params.get(key);
        if (vl == null) {
            return defaultValue;
        }
        return vl;
    }

    protected int getIntParam(HashMap<String, String> params, String name) {
        if (params == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String value = params.get(name);
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + name));
        }
        return 0;
    }

    static {
        LOG = ExoLogger.getLogger(AbstractPollInjector.class);
    }
}

