/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.user.CommonContact;
import org.exoplatform.forum.common.user.ContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class SocialContactProvider
implements ContactProvider {
    private static final Log LOG = ExoLogger.getLogger(SocialContactProvider.class);
    private OrganizationService organizationService;

    public SocialContactProvider(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public CommonContact getCommonContact(String userId) {
        Identity userIdentity;
        CommonContact contact = null;
        IdentityManager identityM = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (identityM != null && (userIdentity = identityM.getOrCreateIdentity("organization", userId, true)) != null) {
            contact = new CommonContact();
            Profile profile = userIdentity.getProfile();
            UserProfile userProfile = null;
            try {
                userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(userId);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not retrieve user profile for " + userId + ": "), (Throwable)e);
            }
            contact.setEmailAddress(profile.getEmail());
            contact.setFullName(profile.getFullName());
            contact.setAvatarUrl(profile.getAvatarUrl());
            contact.setJob(profile.getPosition());
            if (profile.contains("firstName")) {
                contact.setFirstName(profile.getProperty("firstName").toString());
            }
            if (profile.contains("lastName")) {
                contact.setLastName(profile.getProperty("lastName").toString());
            }
            if (profile.contains("gender")) {
                contact.setGender(profile.getProperty("gender").toString());
            }
            if (userProfile != null && userProfile.getUserInfoMap() != null) {
                contact.setBirthday(userProfile.getAttribute("user.bdate"));
            }
            if (userProfile != null && userProfile.getUserInfoMap() != null) {
                String uTelMobWorkNumber = userProfile.getAttribute("user.business-info.telecom.mobile.number");
                String uTelWorkNumber = userProfile.getAttribute("user.business-info.telecom.telephone.number");
                String uTelMobHomeNumber = userProfile.getAttribute("user.home-info.telecom.mobile.number");
                String uTelHomeNumber = userProfile.getAttribute("user.home-info.telecom.telephone.number");
                String workPhone = Arrays.asList(uTelWorkNumber, uTelMobWorkNumber).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
                String homePhone = Arrays.asList(uTelHomeNumber, uTelMobHomeNumber).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
                contact.setWorkPhone(workPhone);
                contact.setHomePhone(homePhone);
            }
            if (profile.contains("urls")) {
                List profiles = (List)profile.getProperty("urls");
                if (profiles != null) {
                    for (Map mapInfo : profiles) {
                        contact.setWebSite(this.getValueByKey(mapInfo, "url", contact.getWebSite()));
                    }
                }
            } else {
                contact.setWebSite(LinkProvider.getProfileUri((String)userId));
            }
        }
        if (contact == null) {
            LOG.warn((Object)String.format("Could not retrieve forum user profile for %s by SocialContactProvider.", userId));
            return new CommonContact();
        }
        return contact;
    }

    private String getValueByKey(Map<String, String> mapInfo, String key, String value) {
        if (mapInfo != null && key.equals(mapInfo.get("key"))) {
            String str = mapInfo.get("value");
            if (value.length() > 0) {
                str = new StringBuffer(value).append(", ").append(str).toString();
            }
            return str;
        }
        return value;
    }
}

