/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.SendMessageInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SendMailJob
implements Job {
    private static Log LOG = ExoLogger.getLogger(SendMailJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            MailService mailService = (MailService)CommonsUtils.getService(MailService.class);
            ForumService forumService = (ForumService)CommonsUtils.getService(ForumService.class);
            Iterator<SendMessageInfo> iter = forumService.getPendingMessages();
            int countEmail = 0;
            while (iter.hasNext()) {
                try {
                    SendMessageInfo messageInfo = iter.next();
                    List<String> emailAddresses = messageInfo.getEmailAddresses();
                    Message message = messageInfo.getMessage();
                    if (message == null || emailAddresses == null || emailAddresses.size() <= 0) continue;
                    message.setFrom(CommonUtils.makeNotificationSender((String)message.getFrom()));
                    ArrayList<String> sentMessages = new ArrayList<String>();
                    for (String address : emailAddresses) {
                        if (sentMessages.contains(address)) continue;
                        message.setTo(address);
                        mailService.sendMessage(message);
                        sentMessages.add(address);
                        ++countEmail;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Could not send email notification", (Throwable)e);
                }
            }
            if (countEmail > 0) {
                LOG.debug((Object)("Email notifications has been sent to " + countEmail + " addresses"));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable send email notification " + e.getMessage()));
        }
    }
}

