/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.text.MessageFormat;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

public class WebUIUtils {
    private static final Log LOG = ExoLogger.getLogger(WebUIUtils.class);
    private static final String SCRIPT_PATTERN = "<script src=\"/forum/syntaxhighlighter/Scripts/{0}\" id=\"script_{1}_UIScriptBBCodeContainer\" type=\"text/javascript\"></script>";

    public static String getRemoteIP() {
        String remoteAddr = "";
        try {
            PortalRequestContext context = Util.getPortalRequestContext();
            remoteAddr = context.getRequest().getRemoteAddr();
        }
        catch (Exception e) {
            LOG.error((Object)"Can not get remote IP", (Throwable)e);
        }
        return remoteAddr;
    }

    public String getLabel(String key) throws Exception {
        return WebUIUtils.getLabel(null, key);
    }

    public static String getLabel(String componentId, String label) {
        if (!StringUtils.isEmpty((String)componentId)) {
            label = componentId.concat(".label.").concat(label);
        }
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            return res.getString(label);
        }
        catch (MissingResourceException e) {
            return label;
        }
    }

    public static String getLabelEscapedJavaScript(String componentId, String label) {
        return StringEscapeUtils.escapeJavaScript((String)WebUIUtils.getLabel(componentId, label));
    }

    public static RequireJS addScripts(String module, String alias) {
        return WebUIUtils.addScripts(module, alias, "");
    }

    public static RequireJS addScripts(String[] scripts) {
        return WebUIUtils.addScripts(null, null, scripts);
    }

    public static RequireJS addScripts(String module, String alias, String ... scripts) {
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        RequireJS requireJS = !CommonUtils.isEmpty(module) ? (!CommonUtils.isEmpty(alias) ? pContext.getJavascriptManager().require("SHARED/" + module, alias) : pContext.getJavascriptManager().require("SHARED/" + module)) : pContext.getJavascriptManager().getRequireJS();
        if (scripts != null) {
            for (int i = 0; i < scripts.length; ++i) {
                String script = scripts[i];
                if (CommonUtils.isEmpty(script)) continue;
                requireJS.addScripts(script + ";");
            }
        }
        return requireJS;
    }

    private static String makeScript(String scriptName, int index) {
        return MessageFormat.format(SCRIPT_PATTERN, scriptName, index);
    }

    public static String attachJSSyntaxHighlighter(List<String> languageOption) {
        StringBuilder scripts = new StringBuilder();
        if (languageOption != null && !languageOption.isEmpty()) {
            int index = 0;
            scripts.append(WebUIUtils.makeScript("shCore.js", index++)).append(WebUIUtils.makeScript("shAutoloader.js", index++));
            for (String lang : languageOption) {
                scripts.append(WebUIUtils.makeScript("shBrush" + lang + ".js", index++));
            }
            scripts.append(WebUIUtils.makeScript("shLegacy.js", index++)).append(WebUIUtils.makeScript("load_syntaxhighlighter.js", index++));
            try {
                String script = "setTimeout(function() {try {SyntaxHighlighter.initLoader();SyntaxHighlighter.all();dp.SyntaxHighlighter.HighlightAll('code');}catch(err){if(window.console && SyntaxHighlighter.config.strings.isAlert) {window.console.log(err);}}}, 500);";
                WebUIUtils.addScripts(new String[]{script});
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to add JavaScripts for SyntaxHighlighter");
            }
        }
        return scripts.toString();
    }

    public static Space getSpaceByContext() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        if (!pcontext.getSiteType().equals((Object)SiteType.GROUP) || !pcontext.getSiteName().startsWith("/spaces")) {
            return null;
        }
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (route == null) {
            String groupId = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
            return spaceService.getSpaceByGroupId(groupId);
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        if (space == null) {
            String groupId = String.format("%s/%s", "/spaces", spacePrettyName);
            space = spaceService.getSpaceByGroupId(groupId);
        }
        return space;
    }
}

