/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class DelayWritesJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(DelayWritesJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)context);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            forumService.writeViews();
            forumService.writeReads();
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)"\n\nUpdate view has been updated by a period login job");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Update view can not execute ...", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

