/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.indexing.listener;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UnifiedSearchForumListener
extends ForumEventListener {
    private static Log log = ExoLogger.getLogger(UnifiedSearchForumListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchForumListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void saveCategory(Category category) {
        if (this.indexingService != null) {
            HashMap<String, Category> content = new HashMap<String, Category>();
            content.put("category", category);
            SearchEntry searchEntry = new SearchEntry("forum", "category", category.getId(), content);
            this.indexingService.add(searchEntry);
        }
    }

    public void saveForum(Forum forum) {
        if (this.indexingService != null) {
            HashMap<String, Forum> content = new HashMap<String, Forum>();
            content.put("forum", forum);
            SearchEntry searchEntry = new SearchEntry("forum", "forum", forum.getId(), content);
            this.indexingService.add(searchEntry);
        }
    }

    public void addTopic(Topic topic) {
        if (this.indexingService != null) {
            HashMap<String, Topic> content = new HashMap<String, Topic>();
            content.put("topic", topic);
            SearchEntry searchEntry = new SearchEntry("forum", "topic", topic.getId(), content);
            this.indexingService.add(searchEntry);
        }
    }

    public void updateTopic(Topic topic) {
        if (this.indexingService != null) {
            HashMap<String, Topic> content = new HashMap<String, Topic>();
            content.put("topic", topic);
            SearchEntryId searchEntryId = new SearchEntryId("forum", "topic", topic.getId());
            this.indexingService.update(searchEntryId, content);
        }
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
        for (Topic topic : topics) {
            this.updateTopic(topic);
        }
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void movePost(List<Post> posts, List<String> srcPostActivityIds, String desTopicPath) {
    }

    public void mergeTopic(Topic topic, String removeActivityId1, String removeActivityId2) {
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
        if (this.indexingService != null) {
            HashMap<String, Topic> content = new HashMap<String, Topic>();
            content.put("topic", splitedTopic);
            SearchEntryId searchEntryId = new SearchEntryId("forum", "topic", splitedTopic.getId());
            this.indexingService.update(searchEntryId, content);
            HashMap<String, Topic> contentNewTopic = new HashMap<String, Topic>();
            contentNewTopic.put("topic", newTopic);
            SearchEntry searchEntry = new SearchEntry("forum", "topic", newTopic.getId(), contentNewTopic);
            this.indexingService.add(searchEntry);
        }
    }

    public void addPost(Post post) {
        if (this.indexingService != null) {
            HashMap<String, Post> content = new HashMap<String, Post>();
            content.put("post", post);
            SearchEntry searchEntry = new SearchEntry("forum", "post", post.getId(), content);
            this.indexingService.add(searchEntry);
        }
    }

    public void updatePost(Post post) {
        if (this.indexingService != null) {
            HashMap<String, Post> content = new HashMap<String, Post>();
            content.put("post", post);
            SearchEntryId searchEntryId = new SearchEntryId("forum", "post", post.getId());
            this.indexingService.update(searchEntryId, content);
        }
    }

    public void updatePost(Post post, int type) {
        this.updatePost(post);
    }

    public void removeActivity(String activityId) {
    }

    public void removeComment(String activityId, String commentId) {
    }
}

