/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.webui.UIGroupSelector;
import org.exoplatform.forum.common.webui.UIPermissionGrid;
import org.exoplatform.forum.common.webui.UIPopupAction;
import org.exoplatform.forum.common.webui.UIPopupContainer;
import org.exoplatform.forum.common.webui.UISelector;
import org.exoplatform.forum.common.webui.UIUserSelect;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/forum/common/UIPermissionPanel.gtmpl", events={@EventConfig(listeners={OpenUserPopupActionListener.class}), @EventConfig(listeners={OpenRoleAndGroupPopupActionListener.class}), @EventConfig(listeners={AddPermissionActionListener.class})}), @ComponentConfig(id="UIPermissionPopupWindow", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={ClosePopupActionListener.class}, name="Close")})})
public class UIPermissionPanel
extends UIContainer
implements UISelector {
    private static final String PERMISSION_INPUT = "permissionInput";
    private static final String PERMISSION_GRID = "UIPermissionGrid";
    private static final String POPUP_WINDOW_ID = "UIPermissionPopupWindow";
    private static final String selectOwner = "UIPermissionPanel.label.SelectOwner";
    private String spaceGroupId = null;

    public UIPermissionPanel() throws Exception {
        this.setId("UIPermissionPanel");
        UIFormStringInput stringInput = new UIFormStringInput(PERMISSION_INPUT, PERMISSION_INPUT, null);
        UIPermissionGrid grid = (UIPermissionGrid)this.createUIComponent(UIPermissionGrid.class, null, PERMISSION_GRID);
        this.addChild((UIComponent)stringInput);
        this.addChild((UIComponent)grid);
    }

    protected void initPlaceholder() throws Exception {
        UIFormStringInput stringInput = (UIFormStringInput)this.getChildById(PERMISSION_INPUT);
        stringInput.setHTMLAttribute("placeholder", WebUIUtils.getLabel(null, selectOwner));
        stringInput.setHTMLAttribute("style", "vertical-align: top; margin:0px; padding-left:3px");
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public void setSpaceGroupId(String spaceGroupId) {
        this.spaceGroupId = spaceGroupId;
    }

    public void setPermission(String spaceGroupId, String ... permissions) {
        this.setSpaceGroupId(spaceGroupId);
        UIPermissionGrid grid = (UIPermissionGrid)this.getChildById(PERMISSION_GRID);
        grid.setPermissions(permissions);
    }

    public String getOwnersByPermission(String permission) {
        UIPermissionGrid grid = (UIPermissionGrid)this.getChildById(PERMISSION_GRID);
        return grid.getOwnersByPermission(permission);
    }

    public void addPermissionForOwners(String permission, String[] owners) {
        UIPermissionGrid grid = (UIPermissionGrid)this.getChildById(PERMISSION_GRID);
        for (String owner : owners) {
            if (owner.length() == 0) continue;
            grid.addPermission(owner, permission);
        }
    }

    public static String[] splitValues(String str) {
        if (!CommonUtils.isEmpty(str)) {
            if ((str = StringUtils.remove((String)str, (String)" ")).contains(",")) {
                str = str.replaceAll(";", ",");
                return str.trim().split(",");
            }
            str = str.replaceAll(",", ";");
            return str.trim().split(";");
        }
        return new String[]{""};
    }

    private static void closePopup(UIPopupWindow popupWindow) {
        popupWindow.setUIComponent(null);
        popupWindow.setShow(false);
        popupWindow.setRendered(false);
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        context.addUIComponentToUpdateByAjax(popupWindow.getParent());
    }

    @Override
    public void updateSelect(String selectField, String value) throws Exception {
        this.addValue(value);
    }

    private void addValue(String value) throws Exception {
        UIFormStringInput input = (UIFormStringInput)this.getChildById(PERMISSION_INPUT);
        if (CommonUtils.isEmpty((String)input.getValue())) {
            input.setValue((Object)value);
        } else {
            input.setValue((Object)((String)input.getValue() + "," + value));
        }
    }

    public static class ClosePopupActionListener
    extends EventListener<UIPopupWindow> {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UIPopupWindow popupWindow = (UIPopupWindow)event.getSource();
            UIPermissionPanel.closePopup(popupWindow);
        }
    }

    public static class AddActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiUserSelector = (UIUserSelect)((Object)event.getSource());
            String values = uiUserSelector.getSelectedUsers();
            UIPermissionPanel uiPermission = (UIPermissionPanel)((UIPortletApplication)uiUserSelector.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(UIPermissionPanel.class);
            uiPermission.addValue(values);
            UIPermissionPanel.closePopup((UIPopupWindow)uiUserSelector.getParent());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPermission);
        }
    }

    public static class OpenRoleAndGroupPopupActionListener
    extends EventListener<UIPermissionPanel> {
        public void execute(Event<UIPermissionPanel> event) throws Exception {
            UIPopupAction popupAction;
            UIPermissionPanel permissionPanel = (UIPermissionPanel)event.getSource();
            UIPopupContainer uiPopupContainer = (UIPopupContainer)((UIPermissionPanel)event.getSource()).getAncestorOfType(UIPopupContainer.class);
            UIUserSelect user = (UIUserSelect)uiPopupContainer.findFirstComponentOfType(UIUserSelect.class);
            if (user != null) {
                UIPopupWindow popupWindow = (UIPopupWindow)user.getAncestorOfType(UIPopupWindow.class);
                UIPermissionPanel.closePopup(popupWindow);
            }
            if ((popupAction = (UIPopupAction)uiPopupContainer.getChild(UIPopupAction.class)) == null) {
                popupAction = (UIPopupAction)uiPopupContainer.addChild(UIPopupAction.class, UIPermissionPanel.POPUP_WINDOW_ID, UIPermissionPanel.POPUP_WINDOW_ID);
            }
            UIPopupWindow uiPopupWindow = (UIPopupWindow)popupAction.getChild(UIPopupWindow.class);
            String type = event.getRequestContext().getRequestParameter("objectId");
            String componentId = "UIMemberShipSelector";
            if ("2".equals(type)) {
                componentId = "UIGroupSelector";
            }
            UIGroupSelector group = (UIGroupSelector)uiPopupContainer.createUIComponent(UIGroupSelector.class, null, componentId);
            group.setType(type);
            group.setSpaceGroupId(permissionPanel.getSpaceGroupId());
            group.setComponent((UIComponent)event.getSource(), new String[]{UIPermissionPanel.PERMISSION_INPUT});
            ((UITree)group.getChild(UITree.class)).setId("UITreeGroupSelector");
            ((UIBreadcumbs)group.getChild(UIBreadcumbs.class)).setId("BreadcumbGroupSelector");
            uiPopupWindow.setUIComponent((UIComponent)group);
            uiPopupWindow.setShow(true);
            uiPopupWindow.setWindowSize(600, 0);
            uiPopupWindow.setRendered(true);
            uiPopupContainer.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }

    public static class OpenUserPopupActionListener
    extends EventListener<UIPermissionPanel> {
        public void execute(Event<UIPermissionPanel> event) throws Exception {
            UIPopupWindow uiPopupWindow;
            UIPermissionPanel permissionPanel = (UIPermissionPanel)event.getSource();
            UIPopupContainer uiPopupContainer = (UIPopupContainer)permissionPanel.getAncestorOfType(UIPopupContainer.class);
            UIGroupSelector uiGroupSelector = (UIGroupSelector)uiPopupContainer.findFirstComponentOfType(UIGroupSelector.class);
            if (uiGroupSelector != null) {
                UIPopupWindow popupWindow = (UIPopupWindow)uiGroupSelector.getAncestorOfType(UIPopupWindow.class);
                UIPermissionPanel.closePopup(popupWindow);
            }
            if ((uiPopupWindow = (UIPopupWindow)uiPopupContainer.getChildById(UIPermissionPanel.POPUP_WINDOW_ID)) == null) {
                uiPopupWindow = (UIPopupWindow)uiPopupContainer.addChild(UIPopupWindow.class, UIPermissionPanel.POPUP_WINDOW_ID, UIPermissionPanel.POPUP_WINDOW_ID);
            }
            UIUserSelect uiUserSelector = (UIUserSelect)uiPopupContainer.createUIComponent(UIUserSelect.class, null, "UIUserSelector");
            uiUserSelector.setShowSearch(true);
            uiUserSelector.setShowSearchUser(true);
            uiPopupWindow.setUIComponent((UIComponent)uiUserSelector);
            uiPopupWindow.setShow(true);
            uiPopupWindow.setWindowSize(740, 400);
            uiPopupWindow.setRendered(true);
            uiPopupContainer.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }

    public static class AddPermissionActionListener
    extends EventListener<UIPermissionPanel> {
        public void execute(Event<UIPermissionPanel> event) throws Exception {
            UIPermissionPanel panel = (UIPermissionPanel)event.getSource();
            UIPermissionGrid grid = (UIPermissionGrid)panel.getChildById(UIPermissionPanel.PERMISSION_GRID);
            String value = event.getRequestContext().getRequestParameter("objectId");
            String errorUser = UserHelper.checkValueUser(value);
            if (!CommonUtils.isEmpty(errorUser)) {
                ((UIFormStringInput)panel.getChildById(UIPermissionPanel.PERMISSION_INPUT)).setValue((Object)"");
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                ApplicationMessage message = new ApplicationMessage("UserNameValidator.msg.error-input", (Object[])new String[]{String.format("\"%s\"", errorUser)}, 1);
                context.getUIApplication().addMessage(message);
                ((PortalRequestContext)context.getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            grid.setOwners(UIPermissionPanel.splitValues(value));
            ((UIFormStringInput)panel.getChildById(UIPermissionPanel.PERMISSION_INPUT)).setValue((Object)"");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)panel);
        }
    }
}

