/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.Post;

public class PostData
implements CachedData<Post> {
    private static final long serialVersionUID = 1L;
    public static final PostData NULL = new PostData(new Post());
    private final String id;
    private final String path;
    private final String owner;
    private final Date createdDate;
    private final String modifiedBy;
    private final Date modifiedDate;
    private final String editReason;
    private final String name;
    private final String message;
    private final String remoteAddr;
    private final String icon;
    private final String link;
    private final boolean isApproved;
    private final boolean isFirstPost;
    private final boolean isHidden;
    private final boolean isWaiting;
    private final boolean isActiveByTopic;
    private final String[] userPrivate;
    private final long numberAttach;
    private final ForumAttachment[] attachments;

    public PostData(Post post) {
        this.id = post.getId();
        this.path = post.getPath();
        this.owner = post.getOwner();
        this.createdDate = post.getCreatedDate();
        this.modifiedBy = post.getModifiedBy();
        this.modifiedDate = post.getModifiedDate();
        this.editReason = post.getEditReason();
        this.name = post.getName();
        this.message = post.getMessage();
        this.remoteAddr = post.getRemoteAddr();
        this.icon = post.getIcon();
        this.link = post.getLink();
        this.isApproved = post.getIsApproved();
        this.isHidden = post.getIsHidden();
        this.isWaiting = post.getIsWaiting();
        this.isFirstPost = post.getIsFirstPost();
        this.isActiveByTopic = post.getIsActiveByTopic();
        this.userPrivate = post.getUserPrivate();
        this.numberAttach = post.getNumberAttach();
        this.attachments = post.getAttachments() != null ? post.getAttachments().toArray(new ForumAttachment[0]) : null;
    }

    public Post build() {
        if (this == NULL) {
            return null;
        }
        Post post = new Post();
        post.setId(this.id);
        post.setPath(this.path);
        post.setOwner(this.owner);
        post.setCreatedDate(this.createdDate);
        post.setModifiedBy(this.modifiedBy);
        post.setModifiedDate(this.modifiedDate);
        post.setEditReason(this.editReason);
        post.setName(this.name);
        post.setMessage(this.message);
        post.setRemoteAddr(this.remoteAddr);
        post.setIcon(this.icon);
        post.setLink(this.link);
        post.setIsApproved(this.isApproved);
        post.setIsHidden(this.isHidden);
        post.setIsWaiting(this.isWaiting);
        post.setIsActiveByTopic(this.isActiveByTopic);
        post.setFirstPost(this.isFirstPost);
        post.setUserPrivate(this.userPrivate);
        post.setNumberAttach(this.numberAttach);
        if (this.attachments != null) {
            post.setAttachments(Arrays.asList(this.attachments));
        }
        return post;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostData postData = (PostData)o;
        return this.isApproved == postData.isApproved && this.isFirstPost == postData.isFirstPost && this.isHidden == postData.isHidden && this.isWaiting == postData.isWaiting && this.isActiveByTopic == postData.isActiveByTopic && this.numberAttach == postData.numberAttach && Objects.equals(this.id, postData.id) && Objects.equals(this.path, postData.path) && Objects.equals(this.owner, postData.owner) && Objects.equals(this.createdDate, postData.createdDate) && Objects.equals(this.modifiedBy, postData.modifiedBy) && Objects.equals(this.modifiedDate, postData.modifiedDate) && Objects.equals(this.editReason, postData.editReason) && Objects.equals(this.name, postData.name) && Objects.equals(this.message, postData.message) && Objects.equals(this.remoteAddr, postData.remoteAddr) && Objects.equals(this.icon, postData.icon) && Objects.equals(this.link, postData.link) && Arrays.equals(this.userPrivate, postData.userPrivate) && Arrays.equals(this.attachments, postData.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.path, this.owner, this.createdDate, this.modifiedBy, this.modifiedDate, this.editReason, this.name, this.message, this.remoteAddr, this.icon, this.link, this.isApproved, this.isFirstPost, this.isHidden, this.isWaiting, this.isActiveByTopic, this.userPrivate, this.numberAttach, this.attachments);
    }
}

