/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.Forum;

public class ForumData
implements CachedData<Forum> {
    public static final ForumData NULL = new ForumData(new Forum());
    private final String id;
    private final String owner;
    private final String path;
    private final int forumOrder;
    private final Date createdDate;
    private final String modifiedBy;
    private final Date modifiedDate;
    private final String lastTopicPath;
    private final String name;
    private final String description;
    private final long postCount;
    private final long topicCount;
    private final String[] notifyWhenAddTopic;
    private final String[] notifyWhenAddPost;
    private final boolean isAutoAddEmailNotify;
    private final boolean isModerateTopic;
    private final boolean isModeratePost;
    private final boolean isClosed;
    private final boolean isLock;
    private final String[] moderators;
    private final String[] createTopicRole;
    private final String[] viewer;
    private final String[] poster;
    private final String[] emailNotification;
    private final String[] banIPs;

    public ForumData(Forum forum) {
        this.id = forum.getId();
        this.owner = forum.getOwner();
        this.path = forum.getPath();
        this.forumOrder = forum.getForumOrder();
        this.createdDate = forum.getCreatedDate();
        this.modifiedBy = forum.getModifiedBy();
        this.modifiedDate = forum.getModifiedDate();
        this.lastTopicPath = forum.getLastTopicPath();
        this.name = forum.getForumName();
        this.description = forum.getDescription();
        this.postCount = forum.getPostCount();
        this.topicCount = forum.getTopicCount();
        this.notifyWhenAddTopic = forum.getNotifyWhenAddTopic();
        this.notifyWhenAddPost = forum.getNotifyWhenAddPost();
        this.isAutoAddEmailNotify = forum.getIsAutoAddEmailNotify();
        this.isModerateTopic = forum.getIsModerateTopic();
        this.isModeratePost = forum.getIsModeratePost();
        this.isClosed = forum.getIsClosed();
        this.isLock = forum.getIsLock();
        this.moderators = forum.getModerators();
        this.createTopicRole = forum.getCreateTopicRole();
        this.viewer = forum.getViewer();
        this.poster = forum.getPoster();
        this.emailNotification = forum.getEmailNotification();
        this.banIPs = forum.getBanIP() != null ? forum.getBanIP().toArray(new String[0]) : null;
    }

    public Forum build() {
        if (this == NULL) {
            return null;
        }
        Forum forum = new Forum();
        forum.setId(this.id);
        forum.setOwner(this.owner);
        forum.setPath(this.path);
        forum.setForumOrder(this.forumOrder);
        forum.setCreatedDate(this.createdDate);
        forum.setModifiedBy(this.modifiedBy);
        forum.setModifiedDate(this.modifiedDate);
        forum.setLastTopicPath(this.lastTopicPath);
        forum.setForumName(this.name);
        forum.setDescription(this.description);
        forum.setPostCount(this.postCount);
        forum.setTopicCount(this.topicCount);
        forum.setNotifyWhenAddTopic(this.notifyWhenAddTopic);
        forum.setNotifyWhenAddPost(this.notifyWhenAddPost);
        forum.setIsAutoAddEmailNotify(this.isAutoAddEmailNotify);
        forum.setIsModerateTopic(this.isModerateTopic);
        forum.setIsModeratePost(this.isModeratePost);
        forum.setIsClosed(this.isClosed);
        forum.setIsLock(this.isLock);
        forum.setModerators(this.moderators);
        forum.setCreateTopicRole(this.createTopicRole);
        forum.setViewer(this.viewer);
        forum.setPoster(this.poster);
        forum.setEmailNotification(this.emailNotification);
        if (this.banIPs != null) {
            forum.setBanIP(Arrays.asList(this.banIPs));
        }
        return forum;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForumData forumData = (ForumData)o;
        return this.forumOrder == forumData.forumOrder && this.postCount == forumData.postCount && this.topicCount == forumData.topicCount && this.isAutoAddEmailNotify == forumData.isAutoAddEmailNotify && this.isModerateTopic == forumData.isModerateTopic && this.isModeratePost == forumData.isModeratePost && this.isClosed == forumData.isClosed && this.isLock == forumData.isLock && Objects.equals(this.id, forumData.id) && Objects.equals(this.owner, forumData.owner) && Objects.equals(this.path, forumData.path) && Objects.equals(this.createdDate, forumData.createdDate) && Objects.equals(this.modifiedBy, forumData.modifiedBy) && Objects.equals(this.modifiedDate, forumData.modifiedDate) && Objects.equals(this.lastTopicPath, forumData.lastTopicPath) && Objects.equals(this.name, forumData.name) && Objects.equals(this.description, forumData.description) && Arrays.equals(this.notifyWhenAddTopic, forumData.notifyWhenAddTopic) && Arrays.equals(this.notifyWhenAddPost, forumData.notifyWhenAddPost) && Arrays.equals(this.moderators, forumData.moderators) && Arrays.equals(this.createTopicRole, forumData.createTopicRole) && Arrays.equals(this.viewer, forumData.viewer) && Arrays.equals(this.poster, forumData.poster) && Arrays.equals(this.emailNotification, forumData.emailNotification) && Arrays.equals(this.banIPs, forumData.banIPs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.owner, this.path, this.forumOrder, this.createdDate, this.modifiedBy, this.modifiedDate, this.lastTopicPath, this.name, this.description, this.postCount, this.topicCount, this.notifyWhenAddTopic, this.notifyWhenAddPost, this.isAutoAddEmailNotify, this.isModerateTopic, this.isModeratePost, this.isClosed, this.isLock, this.moderators, this.createTopicRole, this.viewer, this.poster, this.emailNotification, this.banIPs);
    }
}

