/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl.model;

import java.util.List;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.impl.model.AbstractListAccess;
import org.exoplatform.forum.service.impl.model.PostFilter;

public class PostListAccess
extends AbstractListAccess<Post> {
    private PostFilter filter = null;
    private Type type;

    public PostListAccess(Type type, DataStorage storage, PostFilter filter) {
        this.storage = storage;
        this.filter = filter;
        this.type = type;
    }

    public Post[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        List<Post> got = null;
        switch (this.type) {
            case POSTS: {
                got = this.storage.getPosts(this.filter, offset, limit);
                break;
            }
        }
        this.reCalculate(offset, limit);
        return got.toArray(new Post[got.size()]);
    }

    public int getSize() throws Exception {
        if (this.size < 0) {
            switch (this.type) {
                case POSTS: {
                    this.size = this.storage.getPostsCount(this.filter);
                }
            }
        }
        return this.size;
    }

    public PostFilter getFilter() {
        return this.filter;
    }

    public Post[] load(int pageSelect) throws Exception, IllegalArgumentException {
        int offset = this.getOffset(pageSelect);
        int limit = this.getPageSize();
        return this.load(offset, limit);
    }

    public static enum Type {
        POSTS,
        BY_IP,
        BY_USER;

    }
}

