/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.integration.gamification;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.forum.integration.gamification.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationForumListener
extends ForumEventListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationForumListener.class);
    private static final String GAMIFICATION_FORUM_ADD_POST = "addForumPost";
    private static final String GAMIFICATION_FORUM_ADD_TOPIC = "addForumTopic";
    private static final String GAMIFICATION_FORUM_VOTE_TOPIC = "voteForumTopic";
    protected RuleService ruleService;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected GamificationService gamificationService;
    protected ActivityManager activityManager;
    protected ForumService forumService;

    public GamificationForumListener(RuleService ruleService, IdentityManager identityManager, SpaceService spaceService, GamificationService gamificationService, ActivityManager activityManager, ForumService forumService) {
        this.ruleService = ruleService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.gamificationService = gamificationService;
        this.activityManager = activityManager;
        this.forumService = forumService;
    }

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    public void addPost(Post post) {
        String actorId = this.identityManager.getOrCreateIdentity("organization", post.getOwner(), false).getId();
        this.gamificationService.createHistory(GAMIFICATION_FORUM_ADD_POST, actorId, actorId, ForumUtils.createdSubForumLink(post.toString(), post.getTopicId(), true), "identity");
    }

    public void updatePost(Post post) {
    }

    public void updatePost(Post post, int type) {
    }

    public void addTopic(Topic topic) {
        String actorId = this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId();
        this.gamificationService.createHistory(GAMIFICATION_FORUM_ADD_TOPIC, actorId, actorId, ForumUtils.createdSubForumLink(topic.toString(), topic.getId(), true), "identity");
    }

    public void updateTopic(Topic topic) {
        PropertyChangeEvent[] events = topic.getChangeEvent();
        for (int i = 0; i < events.length; ++i) {
            this.processUpdateTopicType(events[i], topic);
        }
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
    }

    public void removeActivity(String activityId) {
    }

    public void removeComment(String activityId, String commentId) {
    }

    public void movePost(List<Post> list, List<String> list1, String s) {
    }

    public void openTopic(String userId, String topicId) {
    }

    private void processUpdateTopicType(PropertyChangeEvent event, Topic topic) {
        if (Topic.TOPIC_RATING.equals(event.getPropertyName())) {
            String actorId = this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId();
            this.gamificationService.createHistory(GAMIFICATION_FORUM_VOTE_TOPIC, actorId, actorId, ForumUtils.createdSubForumLink(topic.toString(), topic.getId(), true), "identity");
        }
    }
}

