/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.forum.common.conf.ManagedPlugin;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@NameTemplate(value={@Property(key="service", value="forum"), @Property(key="view", value="plugins"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Plugin that allows to initialize data for the forum")
public class ForumInitialDataPlugin
extends ManagedPlugin {
    private static final String TEXT_XML = "text/xml";
    private static final String APPLICATION_ZIP = "application/zip";
    private static Log log = ExoLogger.getLogger(ForumInitialDataPlugin.class);
    private List<String> locations;
    private boolean forceXML = false;

    public ForumInitialDataPlugin(InitParams params) throws Exception {
        ValuesParam vp1 = params.getValuesParam("locations");
        if (vp1 == null) {
            log.warn((Object)("value-param 'location' is missing for " + this.getName() + ". The plugin will not be used"));
        } else {
            this.locations = new ArrayList<String>(vp1.getValues());
        }
    }

    public void setLocation(List<String> locations) {
        this.locations = locations;
    }

    @Managed
    @ManagedDescription(value="The location where forum an XML export file will be looked")
    public List<String> getLocation() {
        return this.locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ByteArrayInputStream> importData() throws RuntimeException {
        try {
            ConfigurationManager configurationService = (ConfigurationManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ConfigurationManager.class);
            ArrayList<ByteArrayInputStream> arrayInputStreams = new ArrayList<ByteArrayInputStream>();
            for (String location : this.locations) {
                if (!this.isZip(location)) {
                    InputStream bis = configurationService.getInputStream(location);
                    byte[] bdata = new byte[bis.available()];
                    bis.read(bdata);
                    arrayInputStreams.add(new ByteArrayInputStream(bdata));
                    continue;
                }
                try (ZipInputStream zipStream = new ZipInputStream(configurationService.getInputStream(location));){
                    ZipEntry entry = null;
                    while ((entry = zipStream.getNextEntry()) != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        int available = -1;
                        byte[] data = new byte[2048];
                        while ((available = zipStream.read(data, 0, 1024)) > -1) {
                            out.write(data, 0, available);
                        }
                        zipStream.closeEntry();
                        out.close();
                        arrayInputStreams.add(new ByteArrayInputStream(out.toByteArray()));
                    }
                }
            }
            return arrayInputStreams;
        }
        catch (Exception e) {
            log.error((Object)("The plugin " + this.getName() + " failed to initialize data " + e));
            throw new RuntimeException(e.getCause());
        }
    }

    boolean isZip(String fileName) {
        MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
        String mimeType = mimeTypeResolver.getMimeType(fileName);
        if (APPLICATION_ZIP.equals(mimeType)) {
            return true;
        }
        if (TEXT_XML.equals(mimeType)) {
            return false;
        }
        throw new RuntimeException("The format " + mimeType + " is not supported. Expecting application/zip or text/xml");
    }

    public String toString() {
        return this.getName() + " (forceXML=" + this.forceXML + ",location=" + this.locations + ")";
    }
}

