/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.poll.service.Poll;

public class Utils {
    public static final String COLON = ":".intern();

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isListEmpty(List<String> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (String string : list) {
            if (Utils.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static Poll calculateVote(Poll poll, String userId, String voteOptions) throws Exception {
        ArrayList<String> userVote = new ArrayList<String>(Arrays.asList(poll.getUserVote()));
        String currentVote = "";
        for (String uv : userVote) {
            if (!uv.startsWith(userId + COLON)) continue;
            currentVote = uv;
            break;
        }
        userVote.remove(currentVote);
        if (voteOptions.indexOf(COLON) > 0) {
            voteOptions = StringUtils.join(new HashSet<String>(Arrays.asList(voteOptions.split(COLON))), (String)COLON);
        }
        userVote.add(userId + COLON + voteOptions);
        int[] votes = new int[poll.getOption().length];
        int total = 0;
        for (String uv : userVote) {
            String[] uvArr = uv.split(COLON);
            for (int i = 1; i < uvArr.length; ++i) {
                int n = Integer.parseInt(uvArr[i].trim());
                votes[n] = votes[n] + 1;
                ++total;
            }
        }
        String[] sVotes = new String[votes.length];
        for (int i = 0; i < sVotes.length; ++i) {
            sVotes[i] = (float)votes[i] / (float)total * 100.0f + "";
        }
        poll.setUserVote(userVote.toArray(new String[0]));
        poll.setVote(sVotes);
        return poll;
    }
}

