/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service.impl;

import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.poll.service.PollSummary;
import org.exoplatform.poll.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@NameTemplate(value={@Property(key="service", value="poll")})
public class PollServiceImpl
implements Startable,
PollService {
    private JCRDataStorage storage_;
    private KSDataLocation dataLocator;
    private static final Log log = ExoLogger.getLogger(PollServiceImpl.class);

    public PollServiceImpl(InitParams params, KSDataLocation locator, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.dataLocator = locator;
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, this.dataLocator);
    }

    @Override
    public void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        this.storage_.addInitialDefaultDataPlugin(plugin);
    }

    public void start() {
        try {
            log.info((Object)"initializing Poll default data...");
            this.storage_.initDefaultData();
        }
        catch (Exception e) {
            log.error((Object)"Failed to initializing default data for poll: ", (Throwable)e);
        }
    }

    public void stop() {
    }

    @Override
    public Poll getPoll(String pollId) throws Exception {
        return this.storage_.getPoll(pollId);
    }

    @Override
    public Poll removePoll(String pollId) {
        return this.storage_.removePoll(pollId);
    }

    @Override
    public void savePoll(Poll poll, boolean isNew, boolean isVote) throws Exception {
        this.storage_.savePoll(poll, isNew, isVote);
    }

    @Override
    public void setClosedPoll(Poll poll) {
        this.storage_.setClosedPoll(poll);
    }

    @Override
    public List<Poll> getPagePoll() throws Exception {
        return this.storage_.getPagePoll();
    }

    @Override
    public boolean hasPermissionInForum(String pollPath, List<String> allInfoOfUser) throws Exception {
        return this.storage_.hasPermissionInForum(pollPath, allInfoOfUser);
    }

    @Override
    public PollSummary getPollSummary(List<String> groupOfUser) throws Exception {
        return this.storage_.getPollSummary(groupOfUser);
    }
}

