/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.request;

import java.util.Map;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.request.ContainerRequest;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;

public class PortletResourceRequest
extends ContainerRequest {
    private final String resourceId;
    private final StateString resourceState;
    private final Map<String, String[]> bodyParameters;
    private final Scope scope;

    public PortletResourceRequest(String windowId, String resourceId, StateString resourceState, Map<String, String[]> bodyParameters, Scope scope) throws IllegalArgumentException {
        super(windowId);
        if (resourceState == null) {
            throw new IllegalArgumentException("No null resource state provided");
        }
        if (scope == null) {
            throw new IllegalArgumentException("No null scope provided");
        }
        this.resourceId = resourceId;
        this.resourceState = resourceState;
        this.bodyParameters = bodyParameters;
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public CacheLevel getCacheability() {
        return this.scope.getCacheability();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public StateString getResourceState() {
        return this.resourceState;
    }

    public Map<String, String[]> getBodyParameters() {
        return this.bodyParameters;
    }

    @Override
    public PageNavigationalState getPageNavigationalState() {
        if (this.scope instanceof PageScope) {
            return ((PageScope)this.scope).getPageNavigationalState();
        }
        return null;
    }

    @Override
    public PortletInvocationResponse invoke(ControllerContext context) throws PortletInvokerException {
        CacheLevel cacheability;
        Mode mode = null;
        WindowState windowState = null;
        PageNavigationalState pageNavigationalState = null;
        Map<String, String[]> publicNS = null;
        StateString portletNS = null;
        if (this.scope instanceof PortletScope) {
            PortletScope portletScope = (PortletScope)this.scope;
            WindowNavigationalState navigationalState = portletScope.getWindowNavigationalState();
            if (navigationalState != null) {
                mode = navigationalState.getMode();
                windowState = navigationalState.getWindowState();
                portletNS = navigationalState.getPortletNavigationalState();
            }
            if (this.scope instanceof PageScope) {
                PageScope pageScope = (PageScope)this.scope;
                pageNavigationalState = pageScope.getPageNavigationalState();
                cacheability = CacheLevel.PAGE;
                if (pageNavigationalState != null) {
                    publicNS = context.getStateControllerContext().getPublicWindowNavigationalState(context, pageNavigationalState, this.windowId);
                }
            } else {
                cacheability = CacheLevel.PORTLET;
            }
        } else {
            cacheability = CacheLevel.FULL;
        }
        if (mode == null) {
            mode = Mode.VIEW;
        }
        if (windowState == null) {
            windowState = WindowState.NORMAL;
        }
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(this.windowId, pageNavigationalState);
        ResourceInvocation resourceInvocation = new ResourceInvocation(portletInvocationContext);
        resourceInvocation.setResourceId(this.resourceId);
        resourceInvocation.setCacheLevel(cacheability);
        resourceInvocation.setMode(mode);
        resourceInvocation.setWindowState(windowState);
        resourceInvocation.setNavigationalState(portletNS);
        resourceInvocation.setPublicNavigationalState(publicNS);
        resourceInvocation.setResourceState(this.resourceState);
        resourceInvocation.setForm(this.bodyParameters != null ? ParameterMap.clone(this.bodyParameters) : null);
        try {
            return context.invoke(this.windowId, resourceInvocation);
        }
        catch (PortletInvokerException e) {
            return null;
        }
    }

    public static class PageScope
    extends PortletScope {
        private final PageNavigationalState pageNavigationalState;

        public PageScope(WindowNavigationalState windowNavigationalState, PageNavigationalState pageNavigationalState) {
            super(windowNavigationalState);
            this.pageNavigationalState = pageNavigationalState;
        }

        public PageNavigationalState getPageNavigationalState() {
            return this.pageNavigationalState;
        }

        @Override
        public CacheLevel getCacheability() {
            return CacheLevel.PAGE;
        }
    }

    public static class PortletScope
    extends FullScope {
        private final WindowNavigationalState windowNavigationalState;

        public PortletScope(WindowNavigationalState windowNavigationalState) {
            this.windowNavigationalState = windowNavigationalState;
        }

        public WindowNavigationalState getWindowNavigationalState() {
            return this.windowNavigationalState;
        }

        @Override
        public CacheLevel getCacheability() {
            return CacheLevel.PORTLET;
        }
    }

    public static class FullScope
    extends Scope {
        @Override
        public CacheLevel getCacheability() {
            return CacheLevel.FULL;
        }
    }

    public static abstract class Scope {
        public abstract CacheLevel getCacheability();
    }
}

