/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.PortletControllerContextSupport;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.request.PortletActionRequest;
import org.gatein.pc.controller.request.PortletRenderRequest;
import org.gatein.pc.controller.request.PortletResourceRequest;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;

public class PortletControllerRequestTestCase
extends TestCase {
    PortletController controller = new PortletController();
    PortletControllerContextSupport context = new PortletControllerContextSupport();
    PortletInvokerSupport invoker = this.context.getInvoker();
    PageNavigationalState pageNS = new PageNavigationalState(false);
    StateString portletNS = new OpaqueStateString("abc");
    WindowNavigationalState windowNS = new WindowNavigationalState(this.portletNS, Mode.EDIT, WindowState.MAXIMIZED);
    ParameterMap body = new ParameterMap(Collections.singletonMap("param", new String[]{"value"}));
    OpaqueStateString is = new OpaqueStateString("is");
    OpaqueStateString rs = new OpaqueStateString("rs");

    public void testPortletControllerActionRequest() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        fooPortlet.addHandler((PortletSupport.InvocationHandler)new PortletSupport.ActionHandler(){

            protected PortletInvocationResponse invoke(ActionInvocation action) throws PortletInvokerException {
                TestCase.assertNotNull((Object)action);
                TestCase.assertEquals((Object)PortletControllerRequestTestCase.this.is, (Object)action.getInteractionState());
                TestCase.assertEquals((Object)PortletControllerRequestTestCase.this.portletNS, (Object)action.getNavigationalState());
                TestCase.assertEquals((Object)Mode.EDIT, (Object)action.getMode());
                TestCase.assertEquals((Object)WindowState.MAXIMIZED, (Object)action.getWindowState());
                TestCase.assertEquals((Object)PortletControllerRequestTestCase.this.body, (Object)action.getForm());
                return new UpdateNavigationalStateResponse();
            }
        });
        PortletActionRequest action = new PortletActionRequest("/webapp1:foo", (StateString)this.is, (Map)this.body, this.windowNS, this.pageNS);
        this.controller.process((ControllerContext)this.context, (ControllerRequest)action);
    }

    public void testPortletControllerRenderRequest() throws PortletInvokerException {
        this.invoker.addPortlet("/webapp1:foo");
        PortletRenderRequest render = new PortletRenderRequest("/webapp1:foo", this.windowNS, new HashMap(), this.pageNS);
        this.controller.process((ControllerContext)this.context, (ControllerRequest)render);
    }

    public void testPortletControllerResourceRequestFullScope() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        ResourceHandlerImpl resourceHandler = new ResourceHandlerImpl();
        resourceHandler.expectedResourceId = "resourceid";
        resourceHandler.expectedRS = this.rs;
        resourceHandler.expectedCacheability = CacheLevel.FULL;
        resourceHandler.expectedPortletNS = null;
        resourceHandler.expectedBody = this.body;
        resourceHandler.expectedMode = Mode.VIEW;
        resourceHandler.expectedWindowState = WindowState.NORMAL;
        resourceHandler.expectedPublicState = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest fullServing = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
        this.controller.process((ControllerContext)this.context, (ControllerRequest)fullServing);
        resourceHandler.expectedBody = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest fullServing2 = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, null, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
        this.controller.process((ControllerContext)this.context, (ControllerRequest)fullServing2);
        resourceHandler.expectedResourceId = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest fullServing3 = new PortletResourceRequest("/webapp1:foo", null, (StateString)this.rs, null, (PortletResourceRequest.Scope)new PortletResourceRequest.FullScope());
        this.controller.process((ControllerContext)this.context, (ControllerRequest)fullServing3);
    }

    public void testPortletControllerResourceRequestPortletScope() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        ResourceHandlerImpl resourceHandler = new ResourceHandlerImpl();
        resourceHandler.expectedResourceId = "resourceid";
        resourceHandler.expectedRS = this.rs;
        resourceHandler.expectedBody = this.body;
        resourceHandler.expectedCacheability = CacheLevel.PORTLET;
        resourceHandler.expectedPortletNS = this.portletNS;
        resourceHandler.expectedMode = Mode.EDIT;
        resourceHandler.expectedWindowState = WindowState.MAXIMIZED;
        resourceHandler.expectedPublicState = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest portletServing = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(this.windowNS));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)portletServing);
        resourceHandler.expectedPortletNS = null;
        resourceHandler.expectedMode = Mode.VIEW;
        resourceHandler.expectedWindowState = WindowState.NORMAL;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest portletServing2 = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(null));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)portletServing2);
        resourceHandler.expectedResourceId = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest portletServing3 = new PortletResourceRequest("/webapp1:foo", null, (StateString)this.rs, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PortletScope(null));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)portletServing3);
    }

    public void testPortletControllerResourceRequestPageScope() throws PortletInvokerException {
        PortletSupport fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        ResourceHandlerImpl resourceHandler = new ResourceHandlerImpl();
        resourceHandler.expectedResourceId = "resourceid";
        resourceHandler.expectedRS = this.rs;
        resourceHandler.expectedBody = this.body;
        resourceHandler.expectedPortletNS = this.portletNS;
        resourceHandler.expectedMode = Mode.EDIT;
        resourceHandler.expectedWindowState = WindowState.MAXIMIZED;
        resourceHandler.expectedCacheability = CacheLevel.PAGE;
        resourceHandler.expectedPublicState = new ParameterMap();
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest pageServing = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(this.windowNS, this.pageNS));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)pageServing);
        resourceHandler.expectedPortletNS = null;
        resourceHandler.expectedMode = Mode.VIEW;
        resourceHandler.expectedWindowState = WindowState.NORMAL;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest pageServing2 = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, (Map)this.body, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(null, this.pageNS));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)pageServing2);
        resourceHandler.expectedBody = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest pageServing3 = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, null, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(null, this.pageNS));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)pageServing3);
        resourceHandler.expectedPublicState = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest pageServing4 = new PortletResourceRequest("/webapp1:foo", "resourceid", (StateString)this.rs, null, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(null, null));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)pageServing4);
        resourceHandler.expectedResourceId = null;
        fooPortlet.addHandler((PortletSupport.InvocationHandler)resourceHandler);
        PortletResourceRequest pageServing5 = new PortletResourceRequest("/webapp1:foo", null, (StateString)this.rs, null, (PortletResourceRequest.Scope)new PortletResourceRequest.PageScope(null, null));
        this.controller.process((ControllerContext)this.context, (ControllerRequest)pageServing5);
    }

    private static class ResourceHandlerImpl
    extends PortletSupport.ResourceHandler {
        private String expectedResourceId;
        private StateString expectedRS;
        private StateString expectedPortletNS;
        private ParameterMap expectedBody;
        private CacheLevel expectedCacheability;
        private Mode expectedMode;
        private WindowState expectedWindowState;
        private ParameterMap expectedPublicState;

        private ResourceHandlerImpl() {
        }

        protected PortletInvocationResponse invoke(ResourceInvocation resServing) throws PortletInvokerException {
            TestCase.assertNotNull((Object)resServing);
            TestCase.assertEquals((String)this.expectedResourceId, (String)resServing.getResourceId());
            TestCase.assertEquals((Object)this.expectedRS, (Object)resServing.getResourceState());
            TestCase.assertEquals((Object)this.expectedCacheability, (Object)resServing.getCacheLevel());
            TestCase.assertEquals((Object)this.expectedPortletNS, (Object)resServing.getNavigationalState());
            TestCase.assertEquals((Object)this.expectedMode, (Object)resServing.getMode());
            TestCase.assertEquals((Object)this.expectedWindowState, (Object)resServing.getWindowState());
            TestCase.assertEquals((Object)this.expectedBody, (Object)resServing.getForm());
            TestCase.assertEquals((Object)this.expectedPublicState, (Object)resServing.getPublicNavigationalState());
            return new UpdateNavigationalStateResponse();
        }
    }
}

