/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.EventPhaseContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.PortletControllerContextSupport;
import org.gatein.pc.controller.WiringEventControllerContext;
import org.gatein.pc.controller.event.AbstractEventControllerContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.WindowEvent;
import org.gatein.pc.controller.handlers.EventProducerActionHandler;
import org.gatein.pc.controller.handlers.FailingEventHandler;
import org.gatein.pc.controller.handlers.NoOpEventHandler;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.response.PageUpdateResponse;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;

public class EventControllerContextFailureTestCase
extends TestCase {
    public static final String DST_WINDOW_ID = "/webappdst.dst";
    private PortletController controller = new PortletController();
    private PortletControllerContextSupport context = new PortletControllerContextSupport();
    private PortletInvokerSupport invoker = this.context.getInvoker();
    private ControllerRequest request;
    private QName srcName;
    private QName dstName;
    private PortletSupport fooPortlet;
    private PortletSupport barPortlet;
    private boolean called;

    protected void setUp() throws Exception {
        this.request = this.context.createActionRequest("/webapp1:foo");
        this.srcName = new QName("ns1", "src");
        this.dstName = new QName("ns2", "dst");
        this.fooPortlet = this.invoker.addPortlet("/webapp1:foo");
        this.barPortlet = this.invoker.addPortlet("/webapp2:bar");
        this.called = false;
    }

    public void testEventControllerContextFailsDuringEventConsumedCallback() throws PortletInvokerException {
        WiringEventControllerContext ecc = new WiringEventControllerContext(){

            @Override
            public void eventConsumed(EventPhaseContext context, WindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
                EventControllerContextFailureTestCase.this.called = true;
                throw new RuntimeException();
            }
        };
        ecc.createWire(this.srcName, "/webapp1:foo", this.dstName, "/webapp2:bar");
        this.context.setEventControllerContext(ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        this.barPortlet.addHandler((PortletSupport.InvocationHandler)new NoOpEventHandler());
        ControllerResponse response = this.controller.process((ControllerContext)this.context, this.request);
        PageUpdateResponse updateResponse = (PageUpdateResponse)response;
        EventControllerContextFailureTestCase.assertEquals((int)0, (int)updateResponse.getEventDistributionStatus());
        EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        this.called = false;
        final Error error = new Error();
        ecc = new WiringEventControllerContext(){

            @Override
            public void eventConsumed(EventPhaseContext context, WindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
                EventControllerContextFailureTestCase.this.called = true;
                throw error;
            }
        };
        ecc.createWire(this.srcName, "/webapp1:foo", this.dstName, "/webapp2:bar");
        this.context.setEventControllerContext(ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        this.barPortlet.addHandler((PortletSupport.InvocationHandler)new NoOpEventHandler());
        try {
            this.controller.process((ControllerContext)this.context, this.request);
            EventControllerContextFailureTestCase.fail();
        }
        catch (Error ignore) {
            EventControllerContextFailureTestCase.assertSame((Object)error, (Object)ignore);
            EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        }
    }

    public void testEventControllerContextFailsDuringEventProducedCallback() throws PortletInvokerException {
        AbstractEventControllerContext ecc = new AbstractEventControllerContext(){

            public Iterable<WindowEvent> eventProduced(EventPhaseContext context, WindowEvent producedEvent, WindowEvent sourceEvent) {
                EventControllerContextFailureTestCase.this.called = true;
                throw new RuntimeException();
            }
        };
        this.context.setEventControllerContext((EventControllerContext)ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        ControllerResponse response = this.controller.process((ControllerContext)this.context, this.request);
        PageUpdateResponse updateResponse = (PageUpdateResponse)response;
        EventControllerContextFailureTestCase.assertEquals((int)0, (int)updateResponse.getEventDistributionStatus());
        EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        this.called = false;
        final Error error = new Error();
        ecc = new AbstractEventControllerContext(){

            public Iterable<WindowEvent> eventProduced(EventPhaseContext context, WindowEvent producedEvent, WindowEvent sourceEvent) {
                EventControllerContextFailureTestCase.this.called = true;
                throw error;
            }
        };
        this.context.setEventControllerContext((EventControllerContext)ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        try {
            this.controller.process((ControllerContext)this.context, this.request);
            EventControllerContextFailureTestCase.fail();
        }
        catch (Error ignore) {
            EventControllerContextFailureTestCase.assertSame((Object)error, (Object)ignore);
            EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        }
    }

    public void testEventControllerContextFailsDuringEventFailedCallback() throws PortletInvokerException {
        WiringEventControllerContext ecc = new WiringEventControllerContext(){

            @Override
            public void eventFailed(EventPhaseContext context, WindowEvent failedEvent, Throwable throwable) {
                EventControllerContextFailureTestCase.this.called = true;
                throw new RuntimeException();
            }
        };
        ecc.createWire(this.srcName, "/webapp1:foo", this.dstName, "/webapp2:bar");
        this.context.setEventControllerContext(ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        this.barPortlet.addHandler((PortletSupport.InvocationHandler)new FailingEventHandler(new RuntimeException()));
        ControllerResponse response = this.controller.process((ControllerContext)this.context, this.request);
        PageUpdateResponse updateResponse = (PageUpdateResponse)response;
        EventControllerContextFailureTestCase.assertEquals((int)0, (int)updateResponse.getEventDistributionStatus());
        EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        this.called = false;
        final Error error = new Error();
        ecc = new WiringEventControllerContext(){

            @Override
            public void eventFailed(EventPhaseContext context, WindowEvent failedEvent, Throwable throwable) {
                EventControllerContextFailureTestCase.this.called = true;
                throw error;
            }
        };
        ecc.createWire(this.srcName, "/webapp1:foo", this.dstName, "/webapp2:bar");
        this.context.setEventControllerContext(ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        this.barPortlet.addHandler((PortletSupport.InvocationHandler)new FailingEventHandler(new RuntimeException()));
        try {
            this.controller.process((ControllerContext)this.context, this.request);
            EventControllerContextFailureTestCase.fail();
        }
        catch (Error ignore) {
            EventControllerContextFailureTestCase.assertSame((Object)error, (Object)ignore);
            EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        }
    }

    public void testEventControllerContextFailsDuringEventDiscardedCallback() throws PortletInvokerException {
        WiringEventControllerContext ecc = new WiringEventControllerContext(){

            @Override
            public void eventDiscarded(EventPhaseContext context, WindowEvent discardedEvent, int cause) {
                TestCase.assertEquals((int)3, (int)cause);
                EventControllerContextFailureTestCase.this.called = true;
                throw new RuntimeException();
            }
        };
        ecc.createWire(this.srcName, "/webapp1:foo", this.dstName, DST_WINDOW_ID);
        this.context.setEventControllerContext(ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        ControllerResponse response = this.controller.process((ControllerContext)this.context, this.request);
        PageUpdateResponse updateResponse = (PageUpdateResponse)response;
        EventControllerContextFailureTestCase.assertEquals((int)0, (int)updateResponse.getEventDistributionStatus());
        EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        this.called = false;
        final Error error = new Error();
        ecc = new WiringEventControllerContext(){

            @Override
            public void eventDiscarded(EventPhaseContext context, WindowEvent discardedEvent, int cause) {
                TestCase.assertEquals((int)3, (int)cause);
                EventControllerContextFailureTestCase.this.called = true;
                throw error;
            }
        };
        ecc.createWire(this.srcName, "/webapp1:foo", this.dstName, DST_WINDOW_ID);
        this.context.setEventControllerContext(ecc);
        this.fooPortlet.addHandler((PortletSupport.InvocationHandler)new EventProducerActionHandler(this.srcName));
        try {
            this.controller.process((ControllerContext)this.context, this.request);
            EventControllerContextFailureTestCase.fail();
        }
        catch (Error ignore) {
            EventControllerContextFailureTestCase.assertSame((Object)error, (Object)ignore);
            EventControllerContextFailureTestCase.assertTrue((boolean)this.called);
        }
    }
}

