/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import jakarta.servlet.ServletException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gatein.common.util.Tools;
import org.gatein.pc.embed.Query;
import org.gatein.pc.embed.Segment;

abstract class Chunk {
    private static final char[] ALPHABET = "0123456789ABCDEF".toCharArray();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected static final BitSet PCHAR = new BitSet();
    protected static final BitSet SEGMENT;
    protected static final BitSet SEGMENT_VALUE;
    protected static final BitSet MATRIX_PARAM_NAME;
    protected static final BitSet MATRIX_PARAM_VALUE;
    protected static final BitSet QUERY_PARAM;

    Chunk() {
    }

    static Chunk parse(String path) throws ServletException {
        return Chunk.parse(path.split("/"), 0, null);
    }

    static Chunk parse(String path, Map<String, String[]> query) throws ServletException {
        return Chunk.parse(path.split("/"), 0, query);
    }

    private static Chunk parse(String[] path, int index, Map<String, String[]> query) throws ServletException {
        if (index < path.length) {
            String s = path[index];
            if (s.length() > 0) {
                LinkedHashMap<String, String[]> parameters;
                String[] vals = s.split(";");
                switch (vals.length) {
                    case 0: {
                        throw new ServletException("Illegal path " + s);
                    }
                    case 1: {
                        parameters = null;
                        break;
                    }
                    default: {
                        parameters = new LinkedHashMap<String, String[]>();
                        for (int i = 1; i < vals.length; ++i) {
                            String[] stringArray;
                            String val = vals[i];
                            int pos = val.indexOf(61);
                            String name = Chunk.decode(val.substring(0, pos), MATRIX_PARAM_NAME);
                            String value = Chunk.decode(val.substring(pos + 1), MATRIX_PARAM_VALUE);
                            Object[] values = parameters.get(name);
                            if (values != null) {
                                stringArray = (String[])Tools.appendTo((Object[])values, (Object)value);
                            } else {
                                String[] stringArray2 = new String[1];
                                stringArray = stringArray2;
                                stringArray2[0] = value;
                            }
                            values = stringArray;
                            parameters.put(name, (String[])values);
                        }
                    }
                }
                return new Segment(Chunk.decode(vals[0], SEGMENT_VALUE), parameters, Chunk.parse(path, index + 1, query));
            }
            return Chunk.parse(path, index + 1, query);
        }
        return new Query(query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeTo(sb, "&");
        return sb.toString();
    }

    protected abstract void writeTo(StringBuilder var1, String var2);

    private static int hexa(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 122;
        }
        return -1;
    }

    protected static String decode(String value) {
        return Chunk.decode(value, PCHAR);
    }

    protected static String decode(String value, BitSet allowed) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < value.length()) {
            byte b;
            char c;
            if ((c = value.charAt(i++)) == '%') {
                if (i + 1 >= value.length()) break;
                int i1 = Character.digit(value.charAt(i++), 16);
                int i2 = Character.digit(value.charAt(i++), 16);
                if (i1 == -1 || i2 == -1) continue;
                b = (byte)((i1 << 4) + i2);
                baos.write(b);
                continue;
            }
            if (allowed.get(c)) {
                baos.write(c);
                continue;
            }
            CharBuffer cb = CharBuffer.allocate(1);
            cb.put(c);
            cb.flip();
            ByteBuffer bytes = UTF_8.encode(cb);
            while (bytes.hasRemaining()) {
                b = bytes.get();
                baos.write(b);
            }
        }
        byte[] bytes = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        CharBuffer chars = UTF_8.decode(buffer);
        return chars.toString();
    }

    protected static void encode(StringBuilder sb, String value, BitSet allowed) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (allowed.get(c)) {
                sb.append(c);
                continue;
            }
            CharBuffer cb = CharBuffer.allocate(1);
            cb.put(c);
            cb.flip();
            ByteBuffer bytes = UTF_8.encode(cb);
            while (bytes.hasRemaining()) {
                byte b = bytes.get();
                sb.append('%');
                sb.append(ALPHABET[b >> 4 & 0xF]);
                sb.append(ALPHABET[b & 0xF]);
            }
        }
    }

    static {
        PCHAR.set(65, 91);
        PCHAR.set(97, 123);
        PCHAR.set(48, 58);
        PCHAR.set(45);
        PCHAR.set(46);
        PCHAR.set(95);
        PCHAR.set(126);
        PCHAR.set(33);
        PCHAR.set(36);
        PCHAR.set(38);
        PCHAR.set(39);
        PCHAR.set(40);
        PCHAR.set(41);
        PCHAR.set(42);
        PCHAR.set(43);
        PCHAR.set(44);
        PCHAR.set(59);
        PCHAR.set(61);
        PCHAR.set(58);
        PCHAR.set(64);
        SEGMENT = new BitSet();
        SEGMENT_VALUE = new BitSet();
        MATRIX_PARAM_NAME = new BitSet();
        MATRIX_PARAM_VALUE = new BitSet();
        SEGMENT.or(PCHAR);
        SEGMENT_VALUE.or(SEGMENT);
        SEGMENT_VALUE.clear(59);
        MATRIX_PARAM_NAME.or(SEGMENT_VALUE);
        MATRIX_PARAM_NAME.clear(61);
        MATRIX_PARAM_VALUE.or(SEGMENT_VALUE);
        QUERY_PARAM = new BitSet();
        QUERY_PARAM.or(PCHAR);
        QUERY_PARAM.set(47);
        QUERY_PARAM.set(63);
        QUERY_PARAM.clear(61);
        QUERY_PARAM.clear(38);
    }
}

