/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.info.PreferencesInfo;
import org.gatein.pc.portlet.impl.info.ContainerPreferenceInfo;

public class ContainerPreferencesInfo
implements PreferencesInfo {
    private final Map<String, PreferenceInfo> content = new HashMap<String, PreferenceInfo>();
    private final Set<String> keys = Collections.unmodifiableSet(this.content.keySet());
    private final String validatorClassName;

    public ContainerPreferencesInfo(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    public String getValidatorClassName() {
        return this.validatorClassName;
    }

    public ContainerPreferenceInfo getContainerPreference(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Preference key must not be null");
        }
        return (ContainerPreferenceInfo)this.content.get(key);
    }

    public void addContainerPreference(String name, List<String> value, boolean readOnly, LocalizedString displayName, LocalizedString description) {
        ContainerPreferenceInfo pref = new ContainerPreferenceInfo(name, displayName, description, readOnly, value);
        this.content.put(pref.getKey(), pref);
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public PreferenceInfo getPreference(String key) {
        return this.getContainerPreference(key);
    }
}

