/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.state.consumer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gatein.common.NotYetImplemented;
import org.gatein.pc.api.InvalidPortletIdException;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStateType;
import org.gatein.pc.api.StateEvent;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.pc.api.state.DestroyCloneFailure;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.api.state.PropertyMap;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.state.InvalidStateIdException;
import org.gatein.pc.portlet.state.NoSuchStateException;
import org.gatein.pc.portlet.state.consumer.ConsumerPersistenceManager;
import org.gatein.pc.portlet.state.consumer.ConsumerPortlet;
import org.gatein.pc.portlet.state.consumer.ConsumerState;
import org.gatein.pc.portlet.state.consumer.ConsumerStateContext;

public class ConsumerPortletInvoker
extends PortletInvokerInterceptor {
    private ConsumerPersistenceManager persistenceManager;

    public PortletContext unwrapCCP(String wrappedCCP) throws InvalidPortletIdException {
        if (wrappedCCP == null) {
            throw new IllegalArgumentException();
        }
        if (!wrappedCCP.startsWith("@")) {
            throw new InvalidPortletIdException(wrappedCCP);
        }
        return PortletContext.createPortletContext((String)wrappedCCP.substring("@".length()));
    }

    public PortletContext unwrapPOP(String wrappedPOPId) throws InvalidPortletIdException {
        if (wrappedPOPId == null) {
            throw new IllegalArgumentException();
        }
        return PortletContext.createPortletContext((String)wrappedPOPId);
    }

    public String wrapCCP(PortletContext ccpCtx) throws InvalidPortletIdException {
        if (ccpCtx == null) {
            throw new IllegalArgumentException();
        }
        return "@" + ccpCtx.getId();
    }

    public String wrapPOP(PortletContext popCtx) throws InvalidPortletIdException {
        if (popCtx == null) {
            throw new IllegalArgumentException();
        }
        if (popCtx.getId().startsWith("@")) {
            throw new IllegalArgumentException("Must not start with @");
        }
        return popCtx.getId();
    }

    public void setPersistenceManager(ConsumerPersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Override
    public Set<Portlet> getPortlets() throws PortletInvokerException {
        return super.getPortlets();
    }

    @Override
    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        return this.getConsumerContext(portletContext).getPortlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContext portletContext = invocation.getTarget();
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        InstanceContext cictx = invocation.getInstanceContext();
        StatefulInstanceContextImpl pictx = new StatefulInstanceContextImpl(cictx);
        try {
            invocation.setTarget(consumerContext.producerPortletContext);
            invocation.setInstanceContext((InstanceContext)pictx);
            PortletInvocationResponse response = super.invoke(invocation);
            PortletContext clonedContext = pictx.clonedContext;
            if (clonedContext != null) {
                if (clonedContext instanceof StatefulPortletContext) {
                    StatefulPortletContext statefulClonedContext = (StatefulPortletContext)clonedContext;
                    Serializable state = statefulClonedContext.getState();
                    PortletStateType stateType = statefulClonedContext.getType();
                    ConsumerState<Serializable> consumerState = new ConsumerState<Serializable>(clonedContext.getId(), stateType, state);
                    String stateId = this.persistenceManager.createState(consumerState);
                    String clonedId = "@" + stateId;
                    StateEvent event = new StateEvent(PortletContext.createPortletContext((String)clonedId), StateEvent.Type.PORTLET_CLONED_EVENT);
                    cictx.onStateEvent(event);
                } else {
                    StateEvent event = new StateEvent(PortletContext.createPortletContext((String)clonedContext.getId()), StateEvent.Type.PORTLET_CLONED_EVENT);
                    cictx.onStateEvent(event);
                }
            } else {
                PortletContext modifiedContext = pictx.modifiedContext;
                if (modifiedContext != null && modifiedContext instanceof StatefulPortletContext) {
                    StatefulPortletContext statefulClonedContext = (StatefulPortletContext)modifiedContext;
                    Serializable state = statefulClonedContext.getState();
                    PortletStateType stateType = statefulClonedContext.getType();
                    try {
                        ConsumerState<Serializable> consumerState = new ConsumerState<Serializable>(modifiedContext.getId(), stateType, state);
                        this.persistenceManager.updateState(consumerContext.stateId, consumerState);
                    }
                    catch (NoSuchStateException e) {
                        e.printStackTrace();
                    }
                    catch (InvalidStateIdException e) {
                        e.printStackTrace();
                    }
                }
            }
            PortletInvocationResponse portletInvocationResponse = response;
            return portletInvocationResponse;
        }
        finally {
            invocation.setTarget(portletContext);
            invocation.setInstanceContext(cictx);
        }
    }

    @Override
    public PortletContext createClone(PortletStateType stateType, PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        PortletContext clonedContext = super.createClone(stateType, consumerContext.producerPortletContext);
        if (clonedContext instanceof StatefulPortletContext) {
            StatefulPortletContext statefulClonedContext = (StatefulPortletContext)clonedContext;
            ConsumerState<Serializable> consumerState = new ConsumerState<Serializable>(clonedContext.getId(), statefulClonedContext.getType(), statefulClonedContext.getState());
            String id = this.persistenceManager.createState(consumerState);
            return PortletContext.createPortletContext((String)("@" + id));
        }
        return clonedContext;
    }

    @Override
    public PortletContext importPortlet(PortletStateType stateType, PortletContext portletContext) throws PortletInvokerException, IllegalArgumentException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        PortletContext importContext = super.importPortlet(stateType, consumerContext.producerPortletContext);
        if (importContext instanceof StatefulPortletContext) {
            StatefulPortletContext statefulimportContext = (StatefulPortletContext)importContext;
            ConsumerState<Serializable> consumerState = new ConsumerState<Serializable>(importContext.getId(), statefulimportContext.getType(), statefulimportContext.getState());
            String id = this.persistenceManager.createState(consumerState);
            return PortletContext.createPortletContext((String)("@" + id));
        }
        return importContext;
    }

    @Override
    public PortletContext exportPortlet(PortletStateType stateType, PortletContext portletContext) throws PortletInvokerException, IllegalArgumentException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        return super.exportPortlet(stateType, consumerContext.producerPortletContext);
    }

    @Override
    public List<DestroyCloneFailure> destroyClones(List<PortletContext> portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        if (portletContexts == null) {
            throw new IllegalArgumentException();
        }
        portletContexts = new ArrayList<PortletContext>(portletContexts);
        for (int i = 0; i < portletContexts.size(); ++i) {
            PortletContext portletContext = portletContexts.get(i);
            ConsumerContext consumerContext = this.getConsumerContext(portletContext);
            portletContexts.set(i, consumerContext.producerPortletContext);
            if (consumerContext.stateId == null) continue;
            try {
                this.persistenceManager.destroyState(consumerContext.stateId);
                continue;
            }
            catch (NoSuchStateException noSuchStateException) {
                continue;
            }
            catch (InvalidStateIdException invalidStateIdException) {
                // empty catch block
            }
        }
        List<DestroyCloneFailure> failures = super.destroyClones(portletContexts);
        return failures;
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext, Set<String> keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        return super.getProperties(consumerContext.producerPortletContext, keys);
    }

    @Override
    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        return super.getProperties(consumerContext.producerPortletContext);
    }

    @Override
    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        ConsumerContext consumerContext = this.getConsumerContext(portletContext);
        PortletContext updatedPortletContext = super.setProperties(consumerContext.producerPortletContext, changes);
        if (updatedPortletContext instanceof StatefulPortletContext) {
            StatefulPortletContext statefulUpdatedPortletContext = (StatefulPortletContext)updatedPortletContext;
            Serializable state = statefulUpdatedPortletContext.getState();
            PortletStateType stateType = statefulUpdatedPortletContext.getType();
            if (consumerContext.stateId == null) {
                throw new NotYetImplemented();
            }
            ConsumerState<Serializable> consumerState = new ConsumerState<Serializable>(updatedPortletContext.getId(), stateType, state);
            try {
                this.persistenceManager.updateState(consumerContext.stateId, consumerState);
            }
            catch (NoSuchStateException noSuchStateException) {
            }
            catch (InvalidStateIdException invalidStateIdException) {}
        } else if (consumerContext.stateId != null) {
            throw new NotYetImplemented();
        }
        return portletContext;
    }

    private ConsumerContext getConsumerContext(PortletContext portletContext) throws IllegalArgumentException, InvalidPortletIdException {
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        String portletId = portletContext.getId();
        if (portletId.startsWith("@")) {
            String stateId = portletId.substring("@".length());
            try {
                ConsumerStateContext stateCtx = this.persistenceManager.loadState(stateId);
                StatefulPortletContext blah = StatefulPortletContext.create((String)stateCtx.getPortletId(), stateCtx.getStateType(), stateCtx.getState());
                return new ConsumerContext(portletContext, (PortletContext)blah, stateId);
            }
            catch (NoSuchStateException e) {
                throw new NoSuchPortletException(portletId);
            }
            catch (InvalidStateIdException e) {
                throw new InvalidPortletIdException(portletId);
            }
        }
        return new ConsumerContext(portletContext, portletContext, null);
    }

    private class ConsumerContext {
        private final PortletContext consumerPortletContext;
        private final PortletContext producerPortletContext;
        private final String stateId;
        private Portlet portlet;

        public ConsumerContext(PortletContext consumerPortletContext, PortletContext producerPortletContext, String stateId) {
            this.consumerPortletContext = consumerPortletContext;
            this.producerPortletContext = producerPortletContext;
            this.stateId = stateId;
        }

        public Portlet getPortlet() throws PortletInvokerException {
            if (this.portlet == null) {
                Portlet producerPortlet = ConsumerPortletInvoker.super.getPortlet(this.producerPortletContext);
                this.portlet = this.stateId == null ? producerPortlet : new ConsumerPortlet(this.consumerPortletContext, producerPortlet);
            }
            return this.portlet;
        }
    }

    private class StatefulInstanceContextImpl
    implements InstanceContext {
        private InstanceContext cictx;
        private PortletContext clonedContext;
        private PortletContext modifiedContext;

        public StatefulInstanceContextImpl(InstanceContext cictx) {
            this.cictx = cictx;
        }

        public String getId() {
            return this.cictx.getId();
        }

        public AccessMode getAccessMode() {
            return this.cictx.getAccessMode();
        }

        public void onStateEvent(StateEvent event) {
            switch (event.getType()) {
                case PORTLET_CLONED_EVENT: {
                    this.clonedContext = event.getPortletContext();
                    break;
                }
                case PORTLET_MODIFIED_EVENT: {
                    this.modifiedContext = event.getPortletContext();
                }
            }
        }

        public PortletStateType<?> getStateType() {
            return ConsumerPortletInvoker.this.persistenceManager.getStateType();
        }
    }
}

