/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.support.info;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.pc.portlet.support.info.ModeInfoSupport;
import org.gatein.pc.portlet.support.info.WindowStateInfoSupport;

public class CapabilitiesInfoSupport
implements CapabilitiesInfo {
    private Set<MediaType> mediaTypes = new HashSet<MediaType>();
    private Set<ModeInfo> modes;
    private Set<WindowStateInfo> windowStates;
    private Set<Locale> locales;

    public CapabilitiesInfoSupport() {
        this.mediaTypes.add(MediaType.TEXT_HTML);
        this.modes = new HashSet<ModeInfo>();
        this.modes.add(new ModeInfoSupport(Mode.VIEW));
        this.modes.add(new ModeInfoSupport(Mode.EDIT));
        this.modes.add(new ModeInfoSupport(Mode.HELP));
        this.windowStates = new HashSet<WindowStateInfo>();
        this.windowStates.add(new WindowStateInfoSupport(WindowState.NORMAL));
        this.windowStates.add(new WindowStateInfoSupport(WindowState.MAXIMIZED));
        this.windowStates.add(new WindowStateInfoSupport(WindowState.MINIMIZED));
        this.locales = new HashSet<Locale>();
        this.locales.add(Locale.ENGLISH);
    }

    public Set<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public Set<ModeInfo> getAllModes() {
        return this.modes;
    }

    public Set<ModeInfo> getModes(MediaType mimeType) {
        if (this.mediaTypes.contains(mimeType)) {
            return this.modes;
        }
        return Collections.emptySet();
    }

    public ModeInfo getMode(Mode value) {
        for (ModeInfo mode : this.getAllModes()) {
            if (!mode.getMode().equals((Object)value)) continue;
            return mode;
        }
        return null;
    }

    public Set<WindowStateInfo> getAllWindowStates() {
        return this.windowStates;
    }

    public Set<WindowStateInfo> getWindowStates(MediaType mimeType) {
        if (this.mediaTypes.contains(mimeType)) {
            return this.windowStates;
        }
        return Collections.emptySet();
    }

    public Set<Locale> getAllLocales() {
        return this.locales;
    }

    public WindowStateInfo getWindowState(WindowState value) {
        for (WindowStateInfo windowState : this.getAllWindowStates()) {
            if (!windowState.getWindowState().equals((Object)value)) continue;
            return windowState;
        }
        return null;
    }

    public Set<Locale> getLocales(MediaType mimeType) {
        if (this.mediaTypes.contains(mimeType)) {
            return this.locales;
        }
        return Collections.emptySet();
    }
}

