/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.container;

public class ObjectSupport {
    private final String id;
    private int created;
    private int started;
    private int stopped;
    private int destroy;
    Callback createCallback;
    Callback startCallback;
    Callback stopCallback;
    Callback destroyCallback;

    public ObjectSupport(String id) {
        this.id = id;
        this.createCallback = null;
        this.startCallback = null;
        this.stopCallback = null;
        this.destroyCallback = null;
    }

    public String getId() {
        return this.id;
    }

    public int getStarted() {
        return this.started;
    }

    public int getStopped() {
        return this.stopped;
    }

    public void create() throws Exception {
        ++this.created;
        if (this.createCallback != null) {
            this.createCallback.execute();
        }
    }

    public void start() throws Exception {
        ++this.started;
        if (this.startCallback != null) {
            this.startCallback.execute();
        }
    }

    public void stop() {
        ++this.stopped;
        if (this.stopCallback != null) {
            this.stopCallback.execute();
        }
    }

    public void destroy() {
        ++this.destroy;
        if (this.destroyCallback != null) {
            this.destroyCallback.execute();
        }
    }

    public static interface Callback {
        public void execute();
    }

    public static class Failure
    implements Callback {
        private RuntimeException failure;

        @Override
        public void execute() {
            this.failure = new RuntimeException();
            throw this.failure;
        }

        public RuntimeException getFailure() {
            return this.failure;
        }
    }
}

