/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2008, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.gatein.pc.samples.google;

/**
 * @author <a href="mailto:chris.laprun@jboss.com">Chris Laprun</a>
 * @version $Revision: 9912 $
 */
public class GoogleWeatherClippingPortlet extends GoogleClippingPortlet
{
   private static final String A_END = "</a>";

   protected String postProcessHTML(String html)
   {
      int begIndex;
      int endIndex;

      // remove add to iGoogle link
      begIndex = html.indexOf(A);
      if (begIndex != -1)
      {
         endIndex = html.indexOf(A_END, begIndex);
         html = html.substring(0, begIndex) + html.substring(endIndex + A_END.length());
      }
      html = html.replaceAll("src=\"\\/\\/", "src=\"http:\\/\\/");

      return super.postProcessHTML(html);
   }
}
