/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.cas;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.xml.InitParams;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.GenericAgent;
import org.gatein.sso.agent.cas.CASAgent;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;

public class CASAgentImpl
extends GenericAgent
implements CASAgent {
    private static Logger log = LoggerFactory.getLogger(CASAgentImpl.class);
    private String casServerUrl;
    private boolean renewTicket;
    private String casServiceUrl;

    public CASAgentImpl(InitParams params) {
    }

    @Override
    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    @Override
    public void setCasServiceUrl(String casServiceUrl) {
        this.casServiceUrl = casServiceUrl;
    }

    @Override
    public void setRenewTicket(boolean renewTicket) {
        this.renewTicket = renewTicket;
    }

    @Override
    public void validateTicket(HttpServletRequest httpRequest, String ticket) throws Exception {
        Cas20ProxyTicketValidator ticketValidator = new Cas20ProxyTicketValidator(this.casServerUrl);
        ticketValidator.setRenew(this.renewTicket);
        Assertion assertion = ticketValidator.validate(ticket, this.casServiceUrl);
        log.debug((Object)"------------------------------------------------------------------------------------");
        log.debug((Object)("Service: " + this.casServiceUrl));
        log.debug((Object)("Principal: " + assertion.getPrincipal().getName()));
        log.debug((Object)"------------------------------------------------------------------------------------");
        String principal = assertion.getPrincipal().getName();
        this.saveSSOCredentials(principal, httpRequest);
    }
}

