/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.http.QueryStringParser;
import org.gatein.common.util.ParameterMap;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public abstract class AbstractLogoutFilter
extends AbstractSSOInterceptor {
    protected String logoutUrl;
    private static final String fileEncoding = System.getProperty("file.encoding");
    private static final String SSO_LOGOUT_FLAG = "SSO_LOGOUT_FLAG";
    private static final String SSO_LOGOUT_REQ_URI = "SSO_LOGOUT_REQ_URI";
    private static final String SSO_LOGOUT_REQ_QUERY_STRING = "SSO_LOGOUT_REQ_QUERY_STRING";
    protected final Log log = ExoLogger.getLogger(this.getClass());

    @Override
    protected void initImpl() {
        this.logoutUrl = this.getInitParameter("LOGOUT_URL");
        this.log.info((Object)("Reading filter configuration: logoutUrl=" + this.logoutUrl));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isLogoutInProgress = this.isLogoutInProgress(httpRequest);
        if (isLogoutInProgress) {
            boolean redirectionSent = this.handleLogout(httpRequest, httpResponse);
            if (redirectionSent) {
                return;
            }
        } else if (httpRequest.getSession().getAttribute(SSO_LOGOUT_FLAG) != null) {
            HttpSession httpSession = httpRequest.getSession();
            String restoredURI = (String)httpSession.getAttribute(SSO_LOGOUT_REQ_URI);
            String restoredQueryString = (String)httpSession.getAttribute(SSO_LOGOUT_REQ_QUERY_STRING);
            httpSession.removeAttribute(SSO_LOGOUT_REQ_URI);
            httpSession.removeAttribute(SSO_LOGOUT_REQ_QUERY_STRING);
            if (restoredURI != null && restoredQueryString != null) {
                Object portalLogoutURI = restoredURI + "?" + restoredQueryString;
                portalLogoutURI = httpResponse.encodeRedirectURL((String)portalLogoutURI);
                httpResponse.sendRedirect((String)portalLogoutURI);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("SSO logout performed. Redirecting to portal logout URI: " + (String)portalLogoutURI));
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    protected boolean isLogoutInProgress(HttpServletRequest request) throws UnsupportedEncodingException {
        if (fileEncoding != null) {
            request.setCharacterEncoding(fileEncoding);
        }
        String action = null;
        String queryString = request.getQueryString();
        if (queryString != null) {
            queryString = queryString.replace("&amp;", "&");
            ParameterMap queryParams = QueryStringParser.getInstance().parseQueryString(queryString);
            String[] portalActions = (String[])queryParams.get("portal:action");
            if (portalActions != null && portalActions.length > 0) {
                action = portalActions[0];
            }
        }
        return action != null && action.equals("Logout");
    }

    protected boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        HttpSession httpSession = httpRequest.getSession();
        if (httpRequest.getSession().getAttribute(SSO_LOGOUT_FLAG) == null) {
            httpSession.setAttribute(SSO_LOGOUT_FLAG, (Object)Boolean.TRUE);
            httpSession.setAttribute(SSO_LOGOUT_REQ_URI, (Object)httpRequest.getRequestURI());
            httpSession.setAttribute(SSO_LOGOUT_REQ_QUERY_STRING, (Object)httpRequest.getQueryString());
            String redirectUrl = this.getRedirectUrl(httpRequest);
            redirectUrl = httpResponse.encodeRedirectURL(redirectUrl);
            httpResponse.sendRedirect(redirectUrl);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Redirecting to SSO logout URL: " + redirectUrl));
            }
            return true;
        }
        httpSession.removeAttribute(SSO_LOGOUT_FLAG);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"SSO logout performed and SSO_LOGOUT_FLAG removed from session. Continue with portal logout");
        }
        return false;
    }

    protected abstract String getRedirectUrl(HttpServletRequest var1);
}

