/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.authentication.callback;

import java.util.Collection;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

@Path(value="/sso/authcallback")
public class AuthenticationHandler
implements ResourceContainer {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationHandler.class);
    private final boolean callbackEnabled;

    public AuthenticationHandler(InitParams params) {
        String callbackEnabledParam = params.getValueParam("ssoCallbackEnabled").getValue();
        this.callbackEnabled = Boolean.parseBoolean(callbackEnabledParam);
    }

    @GET
    @Path(value="/auth/{1}/{2}")
    @Produces(value={"text/plain"})
    public String authenticate(@PathParam(value="1") String username, @PathParam(value="2") String password) {
        if (!this.callbackEnabled) {
            log.warn((Object)"SSO callbacks are disabled!");
            return "Error! SSO callbacks are disabled!";
        }
        try {
            log.debug((Object)("Handle SSO callback authentication. Username: " + username));
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            try {
                authenticator.validateUser(credentials);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Login successful for user " + username));
                }
                return "" + Boolean.TRUE;
            }
            catch (LoginException le) {
                log.debug((Object)("Login failed for user " + username));
                return "" + Boolean.FALSE;
            }
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/roles/{1}")
    @Produces(value={"text/plain"})
    public String getJAASRoles(@PathParam(value="1") String username) {
        if (!this.callbackEnabled) {
            log.warn((Object)"SSO callbacks are disabled!");
            return "Error! SSO callbacks are disabled!";
        }
        try {
            log.debug((Object)("Going to obtain roles for user: " + username));
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            Identity identity = authenticator.createIdentity(username);
            Collection roles = identity.getRoles();
            StringBuilder result = null;
            for (String role : roles) {
                if (result == null) {
                    result = new StringBuilder(role);
                    continue;
                }
                result.append(",").append(role);
            }
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/postauth/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public String authenticatePost(@FormParam(value="username") String username, @FormParam(value="password") String password) {
        return this.authenticate(username, password);
    }

    private ExoContainer getContainer() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer("portal");
        }
        return container;
    }
}

