/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.plugin;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.plugin.HttpResponseContext;

public class RestCallbackCaller {
    private static final Log log = ExoLogger.getLogger(RestCallbackCaller.class);
    private static final String ENCODING_CHARSET = "UTF-8";
    private final String protocol;
    private final String host;
    private final String port;
    private final String pathContext;
    private final boolean isPostHttpMethod;

    public RestCallbackCaller(String protocol, String host, String port, String pathContext, String httpMethod) {
        if (host == null || port == null || pathContext == null) {
            throw new IllegalArgumentException("Host, port and context are mandatory, but some of them is not available in configuration. host=" + host + ", port=" + port + ", context=" + pathContext);
        }
        this.host = host;
        this.port = port;
        this.pathContext = pathContext;
        this.isPostHttpMethod = this.isPostHttpMethod(httpMethod);
        if (protocol == null) {
            protocol = "http";
        }
        this.protocol = protocol;
        log.info((Object)("RestCallbackCaller initialized: " + this));
    }

    public RestCallbackCaller(String callbackURL, String httpMethod) {
        try {
            URL url = new URL(callbackURL);
            this.protocol = url.getProtocol();
            this.host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            this.port = String.valueOf(port);
            String path = url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.pathContext = path;
            this.isPostHttpMethod = this.isPostHttpMethod(httpMethod);
        }
        catch (MalformedURLException mfe) {
            throw new IllegalArgumentException("Bad URL format: " + callbackURL, mfe);
        }
        log.debug((Object)("RestCallbackCaller initialized: " + this));
    }

    private boolean isPostHttpMethod(String httpMethod) {
        boolean isPostHttpMethod;
        if (httpMethod == null || "GET".equalsIgnoreCase(httpMethod)) {
            isPostHttpMethod = false;
        } else if ("POST".equalsIgnoreCase(httpMethod)) {
            isPostHttpMethod = true;
        } else {
            throw new IllegalArgumentException("Illegal httpMethod: " + httpMethod + ". Only GET or POST are allowed");
        }
        return isPostHttpMethod;
    }

    public boolean executeRemoteCall(String username, String password) throws Exception {
        try {
            HttpResponseContext httpResponse = this.sendPortalCallbackRequest(username, password);
            int status = httpResponse.getResponseCode();
            String response = httpResponse.getResponse();
            switch (status) {
                case 200: {
                    if (!response.equals(Boolean.TRUE.toString())) break;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("User " + username + " authenticated successfully via Rest callback!"));
                    }
                    return true;
                }
            }
            log.debug((Object)("Authentication failed for user " + username + ". HTTP status: " + status + ", HTTP response: " + response));
            return false;
        }
        catch (Exception e) {
            log.warn((Object)("Can't authenticate because of error: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private HttpResponseContext sendPortalCallbackRequest(String username, String password) throws IOException {
        String requestURL = null;
        String queryString = null;
        if (this.isPostHttpMethod) {
            StringBuilder builder = new StringBuilder(this.protocol).append("://");
            builder.append(this.host).append(":").append(this.port);
            builder.append("/rest/sso/authcallback/postauth/");
            requestURL = builder.toString();
            queryString = "username=" + URLEncoder.encode(username, ENCODING_CHARSET) + "&password=" + URLEncoder.encode(password, ENCODING_CHARSET);
        } else {
            StringBuilder builder = new StringBuilder(this.protocol).append("://");
            builder.append(this.host).append(":").append(this.port).append("/").append(this.pathContext).append("/rest/sso/authcallback/auth/").append(URLEncoder.encode(username, ENCODING_CHARSET)).append("/").append(URLEncoder.encode(password, ENCODING_CHARSET));
            requestURL = builder.toString();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Rest callback URL: " + requestURL + ", query string: " + queryString + ", isPostMethod: " + this.isPostHttpMethod));
        }
        return this.sendHttpRequest(requestURL, queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponseContext sendHttpRequest(String url, String urlParameters) throws IOException {
        Reader reader = null;
        FilterOutputStream wr = null;
        StringBuilder result = new StringBuilder();
        try {
            int nrOfChars;
            HttpURLConnection connection;
            if (this.isPostHttpMethod) {
                tempURL = new URL((String)url);
                connection = (HttpURLConnection)tempURL.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            } else {
                if (urlParameters != null) {
                    url = (String)url + "?" + urlParameters;
                }
                tempURL = new URL((String)url);
                connection = (HttpURLConnection)tempURL.openConnection();
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            if (this.isPostHttpMethod) {
                connection.setDoOutput(true);
                wr = new DataOutputStream(connection.getOutputStream());
                ((DataOutputStream)wr).writeBytes(urlParameters);
                ((DataOutputStream)wr).flush();
            }
            int statusCode = connection.getResponseCode();
            try {
                reader = new InputStreamReader(connection.getInputStream());
            }
            catch (IOException ioe) {
                reader = new InputStreamReader(connection.getErrorStream());
            }
            char[] buffer = new char[50];
            while ((nrOfChars = reader.read(buffer)) != -1) {
                result.append(buffer, 0, nrOfChars);
            }
            String response = result.toString();
            HttpResponseContext httpResponseContext = new HttpResponseContext(statusCode, response);
            return httpResponseContext;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (wr != null) {
                wr.close();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RestCallbackCaller [ protocol=").append(this.protocol).append(", host=").append(this.host).append(", port=").append(this.port).append(", pathContext=").append(this.pathContext).append(", isPostMethod=").append(this.isPostHttpMethod).append(" ]");
        return builder.toString();
    }
}

