/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.josso.agent.LocalSession;
import org.josso.agent.LocalSessionEvent;
import org.josso.agent.SSOAgent;
import org.josso.agent.SSOAgentConfiguration;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SSOPartnerAppConfig;
import org.josso.agent.SingleSignOnEntry;
import org.josso.gateway.GatewayServiceLocator;
import org.josso.gateway.assertion.exceptions.AssertionNotValidException;
import org.josso.gateway.identity.service.SSOIdentityManagerService;
import org.josso.gateway.identity.service.SSOIdentityProviderService;
import org.josso.gateway.session.exceptions.FatalSSOSessionException;
import org.josso.gateway.session.exceptions.NoSuchSessionException;
import org.josso.gateway.session.exceptions.SSOSessionException;
import org.josso.gateway.session.service.SSOSessionManagerService;

public abstract class AbstractSSOAgent
implements SSOAgent {
    public static final long DEFAULT_SESSION_ACCESS_MIN_INTERVAL = 1000L;
    public static final ThreadLocal<SSOAgentRequest> _currentRequest = new ThreadLocal();
    protected final Map<String, SingleSignOnEntry> cache = new HashMap<String, SingleSignOnEntry>();
    protected final Map<LocalSession, String> reverse = new HashMap<LocalSession, String>();
    protected boolean started = false;
    protected int debug = 0;
    protected GatewayServiceLocator gsl;
    protected SSOSessionManagerService sm;
    protected SSOIdentityManagerService im;
    protected SSOIdentityProviderService ip;
    protected SSOAgentConfiguration _cfg;
    private String _gatewayLoginUrl;
    private String _gatewayLogoutUrl;
    private String _gatewayLoginErrorUrl;
    private String _singlePointOfAccess;
    private long _sessionAccessMinInterval = 1000L;
    private boolean _isStateOnClient = false;
    private long _requestCount;
    private long _l1CacheHits;
    private long _l2CacheHits;

    public void setGatewayServiceLocator(GatewayServiceLocator gsl) {
        this.gsl = gsl;
    }

    public GatewayServiceLocator getGatewayServiceLocator() {
        return this.gsl;
    }

    public SSOSessionManagerService getSSOSessionManager() {
        return this.sm;
    }

    public SSOIdentityManagerService getSSOIdentityManager() {
        return this.im;
    }

    public void setGatewayLoginUrl(String gatewayLoginUrl) {
        this._gatewayLoginUrl = gatewayLoginUrl;
    }

    public String getGatewayLoginUrl() {
        return this._gatewayLoginUrl;
    }

    public String getGatewayLoginErrorUrl() {
        return this._gatewayLoginErrorUrl;
    }

    public void setGatewayLoginErrorUrl(String gatewayLoginErrorUrl) {
        this.log("gatewayLoginErrorUrl is no longer supported, modify your agent config.  Check customLoginUrl in JOSSO Gwy config for alternatives.");
        this._gatewayLoginErrorUrl = gatewayLoginErrorUrl;
    }

    public void setGatewayLogoutUrl(String gatewayLogoutUrl) {
        this._gatewayLogoutUrl = gatewayLogoutUrl;
    }

    public String getGatewayLogoutUrl() {
        return this._gatewayLogoutUrl;
    }

    public void setSessionAccessMinInterval(String v) {
        this.setSessionAccessMinInterval(Long.parseLong(v));
    }

    public long getSessionAccessMinInterval() {
        return this._sessionAccessMinInterval;
    }

    public void setSessionAccessMinInterval(long sessionAccessMinInterval) {
        this._sessionAccessMinInterval = sessionAccessMinInterval;
    }

    public String getSinglePointOfAccess() {
        return this._singlePointOfAccess;
    }

    public void setSinglePointOfAccess(String singlePointOfAccess) {
        this._singlePointOfAccess = singlePointOfAccess;
    }

    public boolean isPartnerApp(String vhost, String contextPath) {
        return this.getPartnerAppConfig(vhost, contextPath) != null;
    }

    public SSOPartnerAppConfig getPartnerAppConfig(String vhost, String contextPath) {
        List<SSOPartnerAppConfig> papps = this._cfg.getSsoPartnerApps();
        if (contextPath == null || "".equals(contextPath)) {
            contextPath = "/";
        }
        for (SSOPartnerAppConfig ssoPartnerAppConfig : papps) {
            if (ssoPartnerAppConfig.getVhost() != null && !ssoPartnerAppConfig.getVhost().equals(vhost) || !contextPath.equals(ssoPartnerAppConfig.getContext())) continue;
            return ssoPartnerAppConfig;
        }
        this.log("No partner application configured for '" + vhost + "' and '" + contextPath + "'");
        return null;
    }

    public void start() {
        try {
            this.sm = this.gsl.getSSOSessionManager();
            this.im = this.gsl.getSSOIdentityManager();
            this.ip = this.gsl.getSSOIdentityProvider();
            for (SSOPartnerAppConfig cfg : this._cfg.getSsoPartnerApps()) {
                if (cfg.getId() != null) continue;
                this.log("ERROR! You should define an ID for partner application " + cfg.getContext());
            }
            if (this.debug > 0) {
                this.log("Agent Started");
            }
        }
        catch (Exception e) {
            this.log("Can't create session/identity managers : \n" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SingleSignOnEntry processRequest(SSOAgentRequest request) {
        try {
            _currentRequest.set(request);
            SingleSignOnEntry singleSignOnEntry = this.execute(request);
            return singleSignOnEntry;
        }
        finally {
            _currentRequest.remove();
        }
    }

    protected SingleSignOnEntry execute(SSOAgentRequest request) {
        try {
            SingleSignOnEntry entry;
            ++this._requestCount;
            int action = request.getAction();
            String jossoSessionId = request.getSessionId();
            LocalSession localSession = request.getLocalSession();
            if (action == 3) {
                try {
                    this.accessSession(request.getRequester(), jossoSessionId);
                }
                catch (SSOSessionException e) {
                    throw new FatalSSOSessionException("Assertion error for session : " + jossoSessionId, e);
                }
                return null;
            }
            if (action == 4) {
                this.sendCustomAuthentication(request);
                return null;
            }
            if (action == 2) {
                String assertionId = request.getAssertionId();
                jossoSessionId = this.resolveAssertion(request.getRequester(), assertionId);
                request.setSessionId(jossoSessionId);
            }
            if (this.debug > 0) {
                this.log("Checking for cached principal for " + jossoSessionId);
            }
            if ((entry = this.lookup(jossoSessionId)) != null) {
                if (this.debug > 0) {
                    this.log(" Found cached principal '" + entry.principal.getName() + "' with auth type '" + entry.authType + "'");
                }
                ++this._l1CacheHits;
                entry = this.accessSession(request.getRequester(), entry, jossoSessionId);
                if (entry != null) {
                    if (this.isAuthenticationAlwaysRequired()) {
                        Principal p = this.authenticate(request);
                        if (this.debug > 0) {
                            this.log("Updating Principal information");
                        }
                        entry.updatePrincipal(p);
                    }
                    this.propagateSecurityContext(request, entry.principal);
                }
                return entry;
            }
            localSession.addSessionListener(this);
            this.associateLocalSession(jossoSessionId, localSession);
            Principal ssoUserPrincipal = this.authenticate(request);
            if (ssoUserPrincipal != null) {
                if (this.debug > 0) {
                    this.log("Principal checked for SSO Session '" + jossoSessionId + "' : " + ssoUserPrincipal);
                }
                this.register(jossoSessionId, ssoUserPrincipal, "JOSSO");
                entry = this.lookup(jossoSessionId);
                entry = this.accessSession(request.getRequester(), entry, jossoSessionId);
                if (entry != null) {
                    this.propagateSecurityContext(request, entry.principal);
                }
                return entry;
            }
            if (this.debug > 0) {
                this.log("There is no associated principal for SSO Session '" + jossoSessionId + "'");
            }
            return null;
        }
        catch (Exception e) {
            this.log("Error processing JOSSO Agent request : " + e.getMessage());
            if (this.debug > 0) {
                this.log("Exception recieved while processing JOSSO Agent request : " + e.getMessage(), e);
            }
            return null;
        }
    }

    protected void propagateSecurityContext(SSOAgentRequest request, Principal principal) {
        throw new UnsupportedOperationException("No support for alternative mechanisms for security context propagation");
    }

    protected String resolveAssertion(String requester, String assertionId) {
        try {
            if (this.debug > 0) {
                this.log("Dereferencing assertion for id '" + assertionId + "'");
            }
            String ssoSessionId = this.ip.resolveAuthenticationAssertion(requester, assertionId);
            if (this.debug > 0) {
                this.log("Dereferencing assertion for id '" + assertionId + "' as SSO Session '" + ssoSessionId + "'");
            }
            return ssoSessionId;
        }
        catch (AssertionNotValidException e) {
            if (this.debug > 0) {
                this.log("Invalid Assertion");
            }
            return null;
        }
        catch (Exception e) {
            this.log(e.getMessage() != null ? e.getMessage() : e.toString(), e);
            return null;
        }
    }

    protected SingleSignOnEntry accessSession(String requester, SingleSignOnEntry entry, String jossoSessionId) {
        if (entry == null) {
            return entry;
        }
        long now = System.currentTimeMillis();
        if (now - entry.lastAccessTime < this.getSessionAccessMinInterval()) {
            ++this._l2CacheHits;
            return entry;
        }
        try {
            if (this.debug > 0) {
                this.log("Notifying keep-alive event for session '" + jossoSessionId + "'");
            }
            this.sm.accessSession(requester, jossoSessionId);
            entry.lastAccessTime = now;
            return entry;
        }
        catch (NoSuchSessionException e) {
            if (this.debug > 0) {
                this.log("SSO Session is no longer valid");
            }
            this.deregister(entry.ssoId);
            return null;
        }
        catch (Exception e) {
            this.log(e.getMessage() != null ? e.getMessage() : e.toString(), e);
            this.deregister(entry.ssoId);
            return null;
        }
    }

    protected void accessSession(String requester, String jossoSessionId) throws SSOSessionException {
        try {
            if (this.debug > 0) {
                this.log("Notifying keep-alive event for session '" + jossoSessionId + "'");
            }
            this.sm.accessSession(requester, jossoSessionId);
        }
        catch (NoSuchSessionException e) {
            if (this.debug > 0) {
                this.log("SSO Session is no longer valid");
            }
            throw e;
        }
        catch (Exception e) {
            this.log(e.getMessage() != null ? e.getMessage() : e.toString(), e);
            throw new SSOSessionException(e.getMessage() != null ? e.getMessage() : e.toString(), e);
        }
    }

    protected abstract void sendCustomAuthentication(SSOAgentRequest var1) throws IOException;

    protected abstract Principal authenticate(SSOAgentRequest var1);

    protected abstract boolean isAuthenticationAlwaysRequired();

    protected abstract void log(String var1);

    protected abstract void log(String var1, Throwable var2);

    public void stop() {
        if (this.debug > 0) {
            this.log("Agent Stopped");
        }
    }

    public void localSessionEvent(LocalSessionEvent event) {
        if (!"destroyLocalSession".equals(event.getType())) {
            return;
        }
        LocalSession session = event.getLocalSession();
        if (this.debug > 0) {
            this.log("Local session destroyed on " + session);
        }
        this.localSessionDestroyedEvent(session);
    }

    public void setConfiguration(SSOAgentConfiguration cfg) {
        this._cfg = cfg;
    }

    public SSOAgentConfiguration getConfiguration() {
        return this._cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localSessionDestroyedEvent(LocalSession session) {
        String ssoId = null;
        Map<LocalSession, String> map = this.reverse;
        synchronized (map) {
            ssoId = this.reverse.remove(session);
        }
        if (ssoId == null) {
            return;
        }
        this.deregister(ssoId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateLocalSession(String ssoId, LocalSession localSession) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso != null) {
            sso.addSession(localSession);
        }
        Map<LocalSession, String> map = this.reverse;
        synchronized (map) {
            this.reverse.put(localSession, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        SingleSignOnEntry sso = null;
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            sso = this.cache.remove(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(ssoId, new SingleSignOnEntry(ssoId, principal, authType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        Map<String, SingleSignOnEntry> map = this.cache;
        synchronized (map) {
            return this.cache.get(ssoId);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public long getRequestCount() {
        return this._requestCount;
    }

    public long getL1CacheHits() {
        return this._l1CacheHits;
    }

    public long getL2CacheHits() {
        return this._l2CacheHits;
    }

    public boolean isStateOnClient() {
        return this._isStateOnClient;
    }

    public void setIsStateOnClient(boolean isStateOnClient) {
        this._isStateOnClient = isStateOnClient;
    }

    public void setStateOnClient(boolean isStateOnClient) {
        this._isStateOnClient = isStateOnClient;
    }
}

