/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.saml.plugin.valve;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.gatein.sso.saml.plugin.valve.SecurityActions;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.api.saml.v2.metadata.MetaDataExtractor;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class BaseFormAuthenticator
extends FormAuthenticator {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected boolean enableAudit = false;
    protected PicketLinkAuditHelper auditHelper = null;
    protected TrustKeyManager keyManager;
    protected SPType spConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String issuerID = null;
    protected String configFile;
    protected transient X509Certificate idpCertificate = null;
    protected transient SAML2HandlerChain chain = null;
    protected transient String samlHandlerChainClass = null;
    protected Map<String, Object> chainConfigOptions = new HashMap<String, Object>();
    protected boolean saveRestoreRequest = true;
    protected Lock chainLock = new ReentrantLock();
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected SAMLConfigurationProvider configProvider = null;
    protected int timerInterval = -1;
    protected Timer timer = null;
    protected String idpAddress = null;

    public void setIdpAddress(String idpAddress) {
        this.idpAddress = idpAddress;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setSamlHandlerChainClass(String samlHandlerChainClass) {
        this.samlHandlerChainClass = samlHandlerChainClass;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public void setSaveRestoreRequest(boolean saveRestoreRequest) {
        this.saveRestoreRequest = saveRestoreRequest;
    }

    public void setConfigProvider(String cp) {
        if (cp == null) {
            throw new IllegalStateException("PL00078: Null Parameter:" + cp);
        }
        Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), cp);
        if (clazz == null) {
            throw new RuntimeException("PL00085: Class Not Loaded:" + cp);
        }
        try {
            this.configProvider = (SAMLConfigurationProvider)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("PL00086: Cannot create instance of:" + cp + ":" + e.getMessage());
        }
    }

    public void setConfigProvider(SAMLConfigurationProvider configProvider) {
        this.configProvider = configProvider;
    }

    public SPType getConfiguration() {
        return this.spConfiguration;
    }

    public void setIssuerID(String issuerID) {
        this.issuerID = issuerID;
    }

    public void setLogOutPage(String logOutPage) {
        logger.warn("Option logOutPage is now configured with the PicketLinkSP element.");
    }

    public void setTimerInterval(String value) {
        if (StringUtil.isNotNull((String)value)) {
            this.timerInterval = Integer.parseInt(value);
        }
    }

    protected boolean validate(Request request) {
        return request.getParameter("SAMLResponse") != null;
    }

    public String getIdentityURL() {
        return this.identityURL;
    }

    public X509Certificate getIdpCertificate() {
        return this.idpCertificate;
    }

    protected boolean localAuthentication(Request request, Response response, LoginConfig loginConfig) throws IOException {
        if (request.getUserPrincipal() == null) {
            logger.samlSPFallingBackToLocalFormAuthentication();
            try {
                return super.authenticate(request, response.getResponse());
            }
            catch (NoSuchMethodError e) {
                try {
                    Method method = super.getClass().getMethod("authenticate", HttpServletRequest.class, HttpServletResponse.class, LoginConfig.class);
                    return (Boolean)method.invoke((Object)this, request.getRequest(), response.getResponse(), loginConfig);
                }
                catch (Exception ex) {
                    throw logger.unableLocalAuthentication((Throwable)ex);
                }
            }
        }
        return true;
    }

    protected abstract String getBinding();

    protected void processIDPMetadataFile(String idpMetadataFile) {
        List keyDescriptors;
        ServletContext servletContext = this.context.getServletContext();
        InputStream is = servletContext.getResourceAsStream(idpMetadataFile);
        if (is == null) {
            return;
        }
        Object metadata = null;
        try {
            Document samlDocument = DocumentUtil.getDocument((InputStream)is);
            SAMLParser parser = new SAMLParser();
            metadata = parser.parse(DocumentUtil.getNodeAsStream((Node)samlDocument));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IDPSSODescriptorType idpSSO = null;
        if (metadata instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entities = (EntitiesDescriptorType)metadata;
            idpSSO = this.handleMetadata(entities);
        } else {
            idpSSO = this.handleMetadata((EntityDescriptorType)metadata);
        }
        if (idpSSO == null) {
            logger.samlSPUnableToGetIDPDescriptorFromMetadata();
            return;
        }
        List endpoints = idpSSO.getSingleSignOnService();
        for (EndpointType endpoint : endpoints) {
            String endpointBinding = endpoint.getBinding().toString();
            if (endpointBinding.contains("HTTP-POST")) {
                endpointBinding = "POST";
            } else if (endpointBinding.contains("HTTP-Redirect")) {
                endpointBinding = "REDIRECT";
            }
            if (!this.getBinding().equals(endpointBinding)) continue;
            this.identityURL = endpoint.getLocation().toString();
            break;
        }
        if ((keyDescriptors = idpSSO.getKeyDescriptor()).size() > 0) {
            this.idpCertificate = MetaDataExtractor.getCertificate((KeyDescriptorType)((KeyDescriptorType)keyDescriptors.get(0)));
        }
    }

    protected void processConfiguration() {
        ServletContext servletContext = this.context.getServletContext();
        InputStream is = null;
        if (StringUtil.isNullOrEmpty((String)this.configFile)) {
            this.configFile = "/WEB-INF/picketlink.xml";
            is = servletContext.getResourceAsStream(this.configFile);
        } else {
            try {
                is = new FileInputStream(this.configFile);
            }
            catch (FileNotFoundException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        try {
            if (this.configProvider != null) {
                try {
                    if (is == null) {
                        is = servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                        if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                            ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                        }
                    } else if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                        ((AbstractSAMLConfigurationProvider)this.configProvider).setConsolidatedConfigFile(is);
                    }
                    this.picketLinkConfiguration = this.configProvider.getPicketLinkConfiguration();
                    this.spConfiguration = this.configProvider.getSPConfiguration();
                }
                catch (ProcessingException e) {
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
                catch (ParsingException e) {
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
            } else if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration((InputStream)is);
                    this.spConfiguration = (SPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    logger.trace((Throwable)e);
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
            } else {
                is = servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                if (is == null) {
                    throw logger.configurationFileMissing(this.configFile);
                }
                this.spConfiguration = ConfigurationUtil.getSPConfiguration((InputStream)is);
            }
            if (this.picketLinkConfiguration != null) {
                String sysProp;
                this.enableAudit = this.picketLinkConfiguration.isEnableAudit();
                if (!this.enableAudit && !"NULL".equals(sysProp = SecurityActions.getSystemProperty("picketlink.audit.enable", "NULL"))) {
                    this.enableAudit = Boolean.parseBoolean(sysProp);
                }
                if (this.enableAudit && this.auditHelper == null) {
                    String securityDomainName = PicketLinkAuditHelper.getSecurityDomainName((ServletContext)servletContext);
                    this.auditHelper = new PicketLinkAuditHelper(securityDomainName);
                }
            }
            if (StringUtil.isNotNull((String)this.spConfiguration.getIdpMetadataFile())) {
                this.processIDPMetadataFile(this.spConfiguration.getIdpMetadataFile());
            } else {
                this.identityURL = this.spConfiguration.getIdentityURL();
            }
            this.serviceURL = this.spConfiguration.getServiceURL();
            this.canonicalizationMethod = this.spConfiguration.getCanonicalizationMethod();
            logger.samlSPSettingCanonicalizationMethod(this.canonicalizationMethod);
            XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
            logger.trace("Identity Provider URL=" + this.identityURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected IDPSSODescriptorType handleMetadata(EntitiesDescriptorType entities) {
        Object entityDescriptor;
        IDPSSODescriptorType idpSSO = null;
        List entityDescs = entities.getEntityDescriptor();
        Iterator iterator = entityDescs.iterator();
        while (iterator.hasNext() && (idpSSO = (entityDescriptor = iterator.next()) instanceof EntitiesDescriptorType ? this.getIDPSSODescriptor(entities) : this.handleMetadata((EntityDescriptorType)entityDescriptor)) == null) {
        }
        return idpSSO;
    }

    protected IDPSSODescriptorType handleMetadata(EntityDescriptorType entityDescriptor) {
        return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)entityDescriptor);
    }

    protected IDPSSODescriptorType getIDPSSODescriptor(EntitiesDescriptorType entities) {
        List entityDescs = entities.getEntityDescriptor();
        Iterator iterator = entityDescs.iterator();
        if (iterator.hasNext()) {
            Object entityDescriptor = iterator.next();
            if (entityDescriptor instanceof EntitiesDescriptorType) {
                return this.getIDPSSODescriptor((EntitiesDescriptorType)entityDescriptor);
            }
            return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)((EntityDescriptorType)entityDescriptor));
        }
        return null;
    }

    protected void initializeHandlerChain() throws ConfigurationException, ProcessingException {
        this.populateChainConfig();
        DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(this.chainConfigOptions);
        Set samlHandlers = this.chain.handlers();
        for (SAML2Handler handler : samlHandlers) {
            handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        this.chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
        this.chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
        if (this.doSupportSignature()) {
            this.chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            String certificateAlias = (String)this.keyManager.getAdditionalOption("X509CERTIFICATE");
            if (certificateAlias != null) {
                this.chainConfigOptions.put("X509CERTIFICATE", this.keyManager.getCertificate(certificateAlias));
            }
        }
    }

    protected void sendToLogoutPage(Request request, Response response, Session session) throws IOException, ServletException {
        RequestDispatcher dispatch = this.context.getServletContext().getRequestDispatcher(this.getConfiguration().getLogOutPage());
        if (dispatch == null) {
            logger.samlSPCouldNotDispatchToLogoutPage(this.getConfiguration().getLogOutPage());
        } else {
            logger.trace("Forwarding request to logOutPage: " + this.getConfiguration().getLogOutPage());
            session.expire();
            try {
                dispatch.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                dispatch.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
            }
        }
    }

    public void testStart() throws LifecycleException {
        this.saveRestoreRequest = false;
        if (this.context == null) {
            throw new RuntimeException("Catalina Context not set up");
        }
        this.startPicketLink();
    }

    protected void startPicketLink() throws LifecycleException {
        SystemPropertiesUtil.ensure();
        Handlers handlers = null;
        if (this.timerInterval > 0) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    BaseFormAuthenticator.this.picketLinkConfiguration = null;
                    BaseFormAuthenticator.this.spConfiguration = null;
                    BaseFormAuthenticator.this.processConfiguration();
                    try {
                        BaseFormAuthenticator.this.initKeyProvider(BaseFormAuthenticator.this.context);
                    }
                    catch (LifecycleException e) {
                        logger.trace(e.getMessage());
                    }
                }
            }, this.timerInterval, (long)this.timerInterval);
        }
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new LifecycleException((Throwable)e1);
            }
        }
        ServletContext servletContext = this.context.getServletContext();
        this.processConfiguration();
        try {
            if (this.picketLinkConfiguration != null) {
                handlers = this.picketLinkConfiguration.getHandlers();
            } else {
                String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
                handlers = ConfigurationUtil.getHandlers((InputStream)servletContext.getResourceAsStream(handlerConfigFileName));
            }
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            this.initKeyProvider(this.context);
            this.populateChainConfig();
            this.initializeHandlerChain();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.picketLinkConfiguration == null) {
            this.picketLinkConfiguration = new PicketLinkType();
            this.picketLinkConfiguration.setIdpOrSP((ProviderType)this.getConfiguration());
            this.picketLinkConfiguration.setHandlers(handlers);
        }
    }

    protected boolean doSupportSignature() {
        if (this.spConfiguration != null) {
            return this.spConfiguration.isSupportsSignature();
        }
        return false;
    }

    protected abstract void initKeyProvider(Context var1) throws LifecycleException;

    public void setAuditHelper(PicketLinkAuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }
}

