/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway.event.security;

import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.Lookup;
import org.josso.auth.Credential;
import org.josso.gateway.event.BaseSSOEvent;

public class SSOIdentityEvent
extends BaseSSOEvent {
    private static final Log logger = LogFactory.getLog(SSOIdentityEvent.class);
    public static final String LOGIN_SUCCESS_EVENT = "authenticationSuccess";
    public static final String LOGIN_FAILED_EVENT = "authenticationFailed";
    public static final String LOGOUT_FAILED_EVENT = "logoutFailed";
    public static final String LOGOUT_SUCCESS_EVENT = "logoutSuccess";
    private String username;
    private String remoteHost;
    private String scheme;
    private String sessionId;

    public SSOIdentityEvent(String remoteHost, String scheme, String username, String sessionId) {
        super(LOGIN_SUCCESS_EVENT, username);
        this.sessionId = sessionId;
        this.scheme = scheme;
        this.remoteHost = remoteHost;
        this.username = username;
    }

    public SSOIdentityEvent(String remoteHost, String scheme, Credential[] credentials, Throwable error) {
        super(LOGIN_FAILED_EVENT, credentials, error);
        this.remoteHost = remoteHost;
        this.scheme = scheme;
        try {
            Principal p = Lookup.getInstance().lookupSecurityDomain().getAuthenticator().getPrincipal(scheme, credentials);
            this.username = p.getName();
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot derive principal name based on credentials ...");
        }
    }

    public SSOIdentityEvent(String remoteHost, String username, String sessionId) {
        super(LOGOUT_SUCCESS_EVENT, username);
        this.sessionId = sessionId;
        this.remoteHost = remoteHost;
        this.username = username;
    }

    public SSOIdentityEvent(String remoteHost, String username, String sessionId, Throwable error) {
        super(LOGOUT_FAILED_EVENT, username, error);
        this.sessionId = sessionId;
        this.remoteHost = remoteHost;
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String toString() {
        return "SSOIdentityEvent['" + this.getType() + "']";
    }
}

