/*
 * Decompiled with CFR 0.152.
 */
package org.josso.agent.config;

import java.util.Map;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.josso.agent.SSOAgent;
import org.josso.agent.config.ComponentKeeper;
import org.josso.agent.reverseproxy.ReverseProxyConfiguration;
import org.josso.gateway.SSOException;
import org.springframework.context.ApplicationContext;

public class SpringComponentKeeperImpl
implements ComponentKeeper {
    private ApplicationContext context;

    public SpringComponentKeeperImpl(String resource) {
        this.context = new ClassPathXmlApplicationContext(resource);
    }

    public SSOAgent fetchSSOAgent() throws Exception {
        Map agents = this.context.getBeansOfType(SSOAgent.class);
        if (agents.values().size() < 1) {
            throw new SSOException("No agent defined. Verify JOSSO Configuration");
        }
        if (agents.values().size() > 1) {
            throw new SSOException("Multiple agent definitions are not supported! Found : " + agents.values().size());
        }
        return (SSOAgent)agents.values().iterator().next();
    }

    public ReverseProxyConfiguration fetchReverseProxyConfiguration() throws Exception {
        return (ReverseProxyConfiguration)this.context.getBean("reverseProxyConfiguration");
    }

    public ApplicationContext getSpringContext() {
        return this.context;
    }
}

