/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class ListServerConfig
extends ServerConfigBase {
    private static final String OPTION_WITH_DEFAULTS = "withdefaults";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String serverName = this.getStringOptionValue("servername");
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            String[] params = new String[]{serverName};
            this.writeLog(0, Level.INFO, "ATTEMPT_LIST_SERVER_CONFIG", params);
            if (serverName.equals("default")) {
                Properties prop = ServerConfiguration.getDefaults(adminSSOToken);
                outputWriter.printlnMessage(FormatUtils.formatProperties(prop));
            } else {
                Properties prop = ServerConfiguration.getServerInstance(adminSSOToken, serverName);
                if (prop != null && !prop.isEmpty()) {
                    if (this.isOptionSet(OPTION_WITH_DEFAULTS)) {
                        Properties defProp = ServerConfiguration.getDefaults(adminSSOToken);
                        defProp.putAll((Map<?, ?>)prop);
                        prop = defProp;
                    }
                    outputWriter.printlnMessage(FormatUtils.formatProperties(prop));
                } else {
                    outputWriter.printlnMessage(this.getResourceString("list-server-config-no-results"));
                }
            }
            this.writeLog(0, Level.INFO, "SUCCEED_LIST_SERVER_CONFIG", params);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("ListServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("ListServerConfig.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_SERVER_CONFIG", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("ListServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
    }
}

