/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.CaseInsensitiveKey;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class CaseInsensitiveProperties
extends Properties {
    public CaseInsensitiveProperties() {
    }

    public CaseInsensitiveProperties(Properties defaults) {
        super(defaults);
    }

    public String getProperty(String key) {
        return (String)super.get(new CaseInsensitiveKey(key));
    }

    public Object setProperty(String key, String value) {
        return super.put(new CaseInsensitiveKey(key), value);
    }

    public boolean containsKey(Object key) {
        boolean retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.containsKey(ciKey);
        } else {
            retval = super.containsKey(key);
        }
        return retval;
    }

    public Object get(Object key) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.get(ciKey);
        } else {
            retval = super.get(key);
        }
        return retval;
    }

    public Set keySet() {
        Set<Object> keys = super.keySet();
        CaseInsensitiveHashSet ciSet = new CaseInsensitiveHashSet();
        Iterator<Object> iter = keys.iterator();
        while (iter.hasNext()) {
            ciSet.add(iter.next());
        }
        return ciSet;
    }

    public Enumeration keys() {
        return new CaseInsensitiveEnumeration(super.keys());
    }

    public Enumeration propertyNames() {
        return new CaseInsensitiveEnumeration(super.propertyNames());
    }

    public Object put(Object key, Object value) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.put(ciKey, value);
        } else {
            retval = super.put(key, value);
        }
        return retval;
    }

    public Object remove(Object key) {
        Object retval;
        if (key instanceof String) {
            CaseInsensitiveKey ciKey = new CaseInsensitiveKey((String)key);
            retval = super.remove(ciKey);
        } else {
            retval = super.remove(key);
        }
        return retval;
    }

    static class CaseInsensitiveEnumeration
    implements Enumeration {
        Enumeration mEnum = null;

        public CaseInsensitiveEnumeration(Enumeration en) {
            this.mEnum = en;
        }

        public boolean hasMoreElements() {
            boolean ans = false;
            if (this.mEnum != null) {
                ans = this.mEnum.hasMoreElements();
            }
            return ans;
        }

        public Object nextElement() {
            String ans = null;
            if (this.mEnum != null) {
                Object nextElem = this.mEnum.nextElement();
                ans = nextElem instanceof CaseInsensitiveKey ? nextElem.toString() : (String)nextElem;
            }
            return ans;
        }
    }
}

