/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.authnsvc.mechanism;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcUtils;
import com.sun.identity.liberty.ws.authnsvc.mechanism.MechanismHandler;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.sm.SMSEntry;

public class SSOTokenMechanismHandler
implements MechanismHandler {
    private static String defaultOrg = SMSEntry.getRootSuffix();
    private static String MECHANISM_SSOTOKEN = "SSOTOKEN";

    public SASLResponse processSASLRequest(SASLRequest saslReq, Message message, String respMessageID) {
        String refToMessageID;
        boolean isFirstRequest;
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("SSOTokenMechanismHandler.processSASLRequest: ");
        }
        boolean bl = isFirstRequest = (refToMessageID = saslReq.getRefToMessageID()) == null || refToMessageID.length() == 0;
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("SSOTokenMechanismHandler.processSASLRequest: refToMessageID = " + refToMessageID);
        }
        SASLResponse saslResp = null;
        byte[] data = saslReq.getData();
        if (data == null) {
            if (isFirstRequest) {
                saslResp = new SASLResponse("continue");
                saslResp.setServerMechanism(MECHANISM_SSOTOKEN);
            } else {
                saslResp = new SASLResponse("abort");
            }
        } else {
            String dataStr = null;
            try {
                dataStr = new String(data, "UTF-8");
            }
            catch (Exception ex) {
                AuthnSvcUtils.debug.error("SSOTokenMechanismHandler.processSASLRequest: ", (Throwable)ex);
            }
            saslResp = dataStr == null ? new SASLResponse("abort") : this.authenticate(dataStr, message);
            if (isFirstRequest) {
                saslResp = new SASLResponse("continue");
                saslResp.setServerMechanism(MECHANISM_SSOTOKEN);
            }
        }
        return saslResp;
    }

    private SASLResponse authenticate(String data, Message message) {
        if (AuthnSvcUtils.debug.messageEnabled()) {
            AuthnSvcUtils.debug.message("SSOTokenMechanismHandler.authenticate: SSOTokenID = " + data);
        }
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            SSOToken token = manager.createSSOToken(data);
            manager.validateToken(token);
            String userDN = token.getPrincipal().getName();
            SASLResponse saslResp = new SASLResponse("OK");
            if (!AuthnSvcUtils.setResourceOfferingAndCredentials((SASLResponse)saslResp, (Message)message, (String)userDN)) {
                return new SASLResponse("abort");
            }
            return saslResp;
        }
        catch (Exception ex) {
            AuthnSvcUtils.debug.error("SSOTokenMechanismHandler.authenticate: ", (Throwable)ex);
            return new SASLResponse("abort");
        }
    }
}

