/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.ApplicationTypeManager;
import com.sun.identity.entitlement.DenyOverride;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.interfaces.ISaveIndex;
import com.sun.identity.entitlement.interfaces.ISearchIndex;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.entitlement.opensso.Notifier;
import com.sun.identity.entitlement.opensso.OpenSSOIndexStore;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitlementService
extends EntitlementConfiguration {
    public static final String SERVICE_NAME = "sunEntitlementService";
    private static final String ATTR_NAME_SUBJECT_ATTR_NAMES = "subjectAttributeNames";
    private static final String CONFIG_APPLICATIONS = "registeredApplications";
    private static final String CONFIG_APPLICATION = "application";
    private static final String SCHEMA_APPLICATIONS = "applications";
    private static final String CONFIG_APPLICATIONTYPE = "applicationType";
    private static final String CONFIG_ACTIONS = "actions";
    private static final String CONFIG_RESOURCES = "resources";
    private static final String CONFIG_CONDITIONS = "conditions";
    private static final String CONFIG_SUBJECTS = "subjects";
    private static final String CONFIG_ENTITLEMENT_COMBINER = "entitlementCombiner";
    private static final String CONFIG_SEARCH_INDEX_IMPL = "searchIndexImpl";
    private static final String CONFIG_SAVE_INDEX_IMPL = "saveIndexImpl";
    private static final String CONFIG_RESOURCE_COMP_IMPL = "resourceComparator";
    private static final String CONFIG_APPLICATION_TYPES = "applicationTypes";
    private static final String CONFIG_SUBJECT_ATTRIBUTES_COLLECTORS = "subjectAttributesCollectors";
    private static final String USE_NEW_CONSOLE = "usenewconsole";
    private static final String MIGRATED_TO_ENTITLEMENT_SERVICES = "migratedtoentitlementservice";
    private static final String XACML_PRIVILEGE_ENABLED = "xacml-privilege-enabled";
    private String realm;
    private static SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());

    public EntitlementService(String realm) {
        this.realm = realm;
    }

    @Override
    public Set<String> getConfiguration(String attrName) {
        SSOToken token = this.getSSOToken();
        return EntitlementService.getConfiguration(token, attrName);
    }

    private static Set<String> getConfiguration(SSOToken token, String attrName) {
        try {
            if (token != null) {
                ServiceSchemaManager smgr = new ServiceSchemaManager(SERVICE_NAME, token);
                AttributeSchema as = smgr.getGlobalSchema().getAttributeSchema(attrName);
                return as.getDefaultValues();
            }
            PrivilegeManager.debug.error("EntitlementService.getAttributeValues: admin token is missing", null);
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.getAttributeValues", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.getAttributeValues", (Throwable)((Object)ex));
        }
        return Collections.EMPTY_SET;
    }

    private static void setConfiguration(SSOToken token, String attrName, Set<String> values) {
        try {
            if (token != null) {
                ServiceSchemaManager smgr = new ServiceSchemaManager(SERVICE_NAME, token);
                AttributeSchema as = smgr.getGlobalSchema().getAttributeSchema(attrName);
                if (as != null) {
                    as.setDefaultValues(values);
                }
            } else {
                PrivilegeManager.debug.error("EntitlementService.getAttributeValues: admin token is missing", null);
            }
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.setAttributeValues", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.setAttributeValues", (Throwable)((Object)ex));
        }
    }

    @Override
    public Set<ApplicationType> getApplicationTypes() {
        HashSet<ApplicationType> results = new HashSet<ApplicationType>();
        try {
            SSOToken token = this.getSSOToken();
            if (token == null) {
                PrivilegeManager.debug.error("EntitlementService.getApplicationTypes : admin sso token is absent", null);
            } else {
                ServiceConfig conf = this.getApplicationTypeCollectionConfig(token);
                Set names = conf.getSubConfigNames();
                for (String name : names) {
                    ServiceConfig appType = conf.getSubConfig(name);
                    Map data = appType.getAttributes();
                    results.add(this.createApplicationType(name, data));
                }
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplicationTypes", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplicationTypes", (Throwable)ex);
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplicationTypes", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplicationTypes", (Throwable)((Object)ex));
        }
        return results;
    }

    private ServiceConfig getApplicationTypeCollectionConfig(SSOToken token) throws SMSException, SSOException {
        ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
        ServiceConfig globalConfig = mgr.getGlobalConfig(null);
        if (globalConfig != null) {
            return globalConfig.getSubConfig(CONFIG_APPLICATION_TYPES);
        }
        return null;
    }

    private Set<String> getActionSet(Map<String, Boolean> actions) {
        HashSet<String> set = new HashSet<String>();
        if (actions != null) {
            for (String k : actions.keySet()) {
                set.add(k + "=" + Boolean.toString(actions.get(k)));
            }
        }
        return set;
    }

    private Map<String, Boolean> getActions(Map<String, Set<String>> data) {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        Set<String> actions = data.get(CONFIG_ACTIONS);
        for (String a : actions) {
            int index = a.indexOf(61);
            String name = a;
            Boolean defaultVal = Boolean.TRUE;
            if (index != -1) {
                name = a.substring(0, index);
                defaultVal = Boolean.parseBoolean(a.substring(index + 1));
            }
            results.put(name, defaultVal);
        }
        return results;
    }

    private String getAttribute(Map<String, Set<String>> data, String attributeName) {
        Set<String> set = data.get(attributeName);
        return set != null && !set.isEmpty() ? set.iterator().next() : null;
    }

    private Set<String> getSet(String str) {
        HashSet<String> set = new HashSet<String>();
        if (str != null) {
            set.add(str);
        }
        return set;
    }

    private Application getRawApplication(String name) {
        SSOToken token = this.getSSOToken();
        Set<Application> applications = this.getRawApplications(token);
        for (Application a : applications) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    private Application getApplication(String name) {
        Set<Application> applications = this.getApplications();
        for (Application a : applications) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    private SSOToken getSSOToken() {
        return this.getAdminSubject() == PrivilegeManager.superAdminSubject ? adminToken : SubjectUtils.getSSOToken(this.getAdminSubject());
    }

    @Override
    public Set<Application> getApplications() {
        boolean hasWebAgent = false;
        Set<Application> results = this.getApplications(this.realm);
        for (Application app : results) {
            if (hasWebAgent) continue;
            hasWebAgent = app.getName().equals("iPlanetAMWebAgentService");
        }
        SSOToken token = this.getSSOToken();
        if (OpenSSOIndexStore.isOrgAliasMappingResourceEnabled(token) && !hasWebAgent) {
            Set<Application> rootApps = this.getApplications("/");
            for (Application a : rootApps) {
                if (!a.getName().equals("iPlanetAMWebAgentService")) continue;
                try {
                    Set<String> resources = OpenSSOIndexStore.getOrgAliasMappingResources(this.realm, "iPlanetAMWebAgentService");
                    Application clone = a.refers(this.realm, resources);
                    results.add(clone);
                }
                catch (SMSException ex) {
                    PrivilegeManager.debug.error("EntitlementService.getApplications", (Throwable)ex);
                }
                break;
            }
        }
        return results;
    }

    private Set<Application> getApplications(String curRealm) {
        SSOToken token = this.getSSOToken();
        Set<Application> results = this.getRawApplications(token, curRealm);
        for (Application app : results) {
            Set<String> resources = app.getResources();
            HashSet<String> res = new HashSet<String>();
            for (String r : resources) {
                int idx = r.indexOf(9);
                if (idx != -1) {
                    res.add(r.substring(idx + 1));
                    continue;
                }
                res.add(r);
            }
            app.setResources(res);
        }
        return results;
    }

    private Set<Application> getRawApplications(SSOToken token) {
        if (this.realm.startsWith("o=sunamhiddenrealm")) {
            this.realm = "/";
        }
        return this.getRawApplications(token, this.realm);
    }

    private Set<Application> getRawApplications(SSOToken token, String curRealm) {
        HashSet<Application> results = new HashSet<Application>();
        try {
            if (token != null) {
                ServiceConfig conf;
                ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
                ServiceConfig orgConfig = mgr.getOrganizationConfig(curRealm, null);
                if (orgConfig != null && (conf = orgConfig.getSubConfig(CONFIG_APPLICATIONS)) != null) {
                    Set names = conf.getSubConfigNames();
                    for (String name : names) {
                        ServiceConfig applConf = conf.getSubConfig(name);
                        Map data = applConf.getAttributes();
                        Application app = this.createApplication(curRealm, name, data);
                        results.add(app);
                    }
                }
            } else {
                PrivilegeManager.debug.error("EntitlementService.getApplications, admin token is missing", null);
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplications", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplications", (Throwable)ex);
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplications", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.getApplications", (Throwable)((Object)ex));
        }
        return results;
    }

    private static Class getEntitlementCombiner(String className) {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("EntitlementService.getEntitlementCombiner", (Throwable)ex);
            return DenyOverride.class;
        }
    }

    @Override
    public void addSubjectAttributeNames(String applicationName, Set<String> names) throws EntitlementException {
        if (names == null || names.isEmpty()) {
            return;
        }
        try {
            SSOToken token = this.getSSOToken();
            if (token == null) {
                throw new EntitlementException(225);
            }
            ServiceConfig applConf = this.getApplicationSubConfig(token, this.realm, applicationName);
            if (applConf != null) {
                HashSet<String> orig = (HashSet<String>)applConf.getAttributes().get(ATTR_NAME_SUBJECT_ATTR_NAMES);
                if (orig == null || orig.isEmpty()) {
                    orig = new HashSet<String>();
                }
                orig.addAll(names);
                HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
                map.put(ATTR_NAME_SUBJECT_ATTR_NAMES, orig);
                applConf.setAttributes(map);
            }
        }
        catch (SMSException ex) {
            throw new EntitlementException(220, (Throwable)ex);
        }
        catch (SSOException ex) {
            throw new EntitlementException(220, (Throwable)((Object)ex));
        }
    }

    @Override
    public void addApplicationAction(String appName, String name, Boolean defVal) throws EntitlementException {
        try {
            Map data;
            Map<String, Set<String>> result;
            SSOToken token = SubjectUtils.getSSOToken(this.getAdminSubject());
            if (token == null) {
                throw new EntitlementException(226);
            }
            ServiceConfig applConf = this.getApplicationSubConfig(token, this.realm, appName);
            if (applConf != null && (result = this.addAction(data = applConf.getAttributes(), name, defVal)) != null) {
                applConf.setAttributes(result);
            }
        }
        catch (SMSException ex) {
            throw new EntitlementException(221, (Throwable)ex);
        }
        catch (SSOException ex) {
            throw new EntitlementException(221, (Throwable)((Object)ex));
        }
    }

    private ServiceConfig getApplicationSubConfig(SSOToken token, String realm, String appName) throws SMSException, SSOException {
        ServiceConfig conf;
        ServiceConfig applConf = null;
        ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
        ServiceConfig orgConfig = mgr.getOrganizationConfig(realm, null);
        if (orgConfig != null && (conf = orgConfig.getSubConfig(CONFIG_APPLICATIONS)) != null) {
            applConf = conf.getSubConfig(appName);
        }
        return applConf;
    }

    private Map<String, Set<String>> addAction(Map<String, Set<String>> data, String name, Boolean defVal) throws EntitlementException {
        HashMap<String, Set<String>> results = null;
        Map<String, Boolean> actionMap = this.getActions(data);
        if (actionMap.keySet().contains(name)) {
            Object[] args = new Object[]{name};
            throw new EntitlementException(222, args);
        }
        Set<String> actions = data.get(CONFIG_ACTIONS);
        HashSet<String> cloned = new HashSet<String>();
        cloned.addAll(actions);
        cloned.add(name + "=" + defVal.toString());
        results = new HashMap<String, Set<String>>();
        results.put(CONFIG_ACTIONS, cloned);
        return results;
    }

    @Override
    public void removeApplication(String name) throws EntitlementException {
        try {
            ServiceConfig conf = this.getApplicationCollectionConfig(this.realm);
            if (conf != null) {
                conf.removeSubConfig(name);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("realm", this.realm);
                Notifier.submit("applicationsChanged", params);
            }
        }
        catch (SMSException ex) {
            Object[] args = new Object[]{name};
            throw new EntitlementException(230, args);
        }
        catch (SSOException ex) {
            Object[] args = new Object[]{name};
            throw new EntitlementException(230, args);
        }
    }

    @Override
    public void removeApplication(String name, Set<String> resources) throws EntitlementException {
        Application appl = this.getApplication(name);
        if (appl != null) {
            Application store = this.getStorableApplication(appl, false);
            if (store.getResources().isEmpty()) {
                this.removeApplication(name);
            } else {
                this.storeApplication(appl, false);
            }
        }
    }

    @Override
    public void removeApplicationType(String name) throws EntitlementException {
        try {
            SSOToken token = SubjectUtils.getSSOToken(this.getAdminSubject());
            if (token == null) {
                Object[] arg = new Object[]{name};
                throw new EntitlementException(245, arg);
            }
            ServiceConfig conf = this.getApplicationTypeCollectionConfig(token);
            if (conf != null) {
                conf.removeSubConfig(name);
            }
        }
        catch (SMSException ex) {
            Object[] arg = new Object[]{name};
            throw new EntitlementException(240, arg, ex);
        }
        catch (SSOException ex) {
            Object[] arg = new Object[]{name};
            throw new EntitlementException(240, arg, (Throwable)((Object)ex));
        }
    }

    private ServiceConfig getApplicationCollectionConfig(String realm) throws SMSException, SSOException {
        SSOToken token = this.getSSOToken();
        ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
        ServiceConfig orgConfig = mgr.getOrganizationConfig(realm, null);
        if (orgConfig != null) {
            return orgConfig.getSubConfig(CONFIG_APPLICATIONS);
        }
        return null;
    }

    private ServiceConfig createApplicationCollectionConfig(String realm) throws SMSException, SSOException {
        ServiceConfig sc = null;
        SSOToken token = SubjectUtils.getSSOToken(this.getAdminSubject());
        ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
        ServiceConfig orgConfig = mgr.getOrganizationConfig(realm, null);
        if (orgConfig != null) {
            sc = orgConfig.getSubConfig(CONFIG_APPLICATIONS);
        }
        if (sc == null) {
            orgConfig.addSubConfig(CONFIG_APPLICATIONS, SCHEMA_APPLICATIONS, 0, Collections.EMPTY_MAP);
            sc = orgConfig.getSubConfig(CONFIG_APPLICATIONS);
        }
        return sc;
    }

    @Override
    public void storeApplication(Application appl) throws EntitlementException {
        this.storeApplication(appl, true);
    }

    public void storeApplication(Application appl, boolean add) throws EntitlementException {
        try {
            ServiceConfig orgConfig = this.createApplicationCollectionConfig(this.realm);
            ServiceConfig appConfig = orgConfig.getSubConfig(appl.getName());
            if (appConfig == null) {
                orgConfig.addSubConfig(appl.getName(), CONFIG_APPLICATION, 0, this.getApplicationData(appl, add));
            } else {
                appConfig.setAttributes(this.getApplicationData(appl, add));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("realm", this.realm);
            Notifier.submit("applicationsChanged", params);
        }
        catch (SMSException ex) {
            Object[] arg = new Object[]{appl.getName()};
            throw new EntitlementException(231, arg, ex);
        }
        catch (SSOException ex) {
            Object[] arg = new Object[]{appl.getName()};
            throw new EntitlementException(231, arg, (Throwable)((Object)ex));
        }
    }

    @Override
    public void storeApplicationType(ApplicationType applicationType) throws EntitlementException {
        try {
            SSOToken token = SubjectUtils.getSSOToken(this.getAdminSubject());
            if (token == null) {
                Object[] arg = new Object[]{applicationType.getName()};
                throw new EntitlementException(246, arg);
            }
            ServiceConfig conf = this.getApplicationTypeCollectionConfig(token);
            if (conf != null) {
                ServiceConfig sc = conf.getSubConfig(applicationType.getName());
                if (sc == null) {
                    conf.addSubConfig(applicationType.getName(), CONFIG_APPLICATIONTYPE, 0, this.getApplicationTypeData(applicationType));
                } else {
                    sc.setAttributes(this.getApplicationTypeData(applicationType));
                }
            }
        }
        catch (SMSException ex) {
            Object[] arg = new Object[]{applicationType.getName()};
            throw new EntitlementException(241, arg, ex);
        }
        catch (SSOException ex) {
            Object[] arg = new Object[]{applicationType.getName()};
            throw new EntitlementException(241, arg, (Throwable)((Object)ex));
        }
    }

    private Map<String, Set<String>> getApplicationTypeData(ApplicationType applType) {
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put(CONFIG_ACTIONS, this.getActionSet(applType.getActions()));
        ISaveIndex sIndex = applType.getSaveIndex();
        String saveIndexClassName = sIndex != null ? sIndex.getClass().getName() : null;
        data.put(CONFIG_SAVE_INDEX_IMPL, saveIndexClassName == null ? Collections.EMPTY_SET : this.getSet(saveIndexClassName));
        ISearchIndex searchIndex = applType.getSearchIndex();
        String searchIndexClassName = searchIndex != null ? searchIndex.getClass().getName() : null;
        data.put(CONFIG_SEARCH_INDEX_IMPL, searchIndexClassName == null ? Collections.EMPTY_SET : this.getSet(searchIndexClassName));
        ResourceName recComp = applType.getResourceComparator();
        String resCompClassName = recComp != null ? recComp.getClass().getName() : null;
        data.put(CONFIG_RESOURCE_COMP_IMPL, resCompClassName == null ? Collections.EMPTY_SET : this.getSet(resCompClassName));
        return data;
    }

    private Map<String, Integer> getResourceCount(Set<String> res) {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (String r : res) {
            int idx = r.indexOf(9);
            if (idx == -1) continue;
            try {
                String resource = r.substring(idx + 1);
                int cnt = Integer.parseInt(r.substring(0, idx));
                results.put(resource, cnt);
            }
            catch (NumberFormatException e) {
                results.put(r, 1);
            }
        }
        return results;
    }

    private Application getStorableApplication(Application app, boolean add) {
        Application existing = this.getRawApplication(app.getName());
        Map<String, Integer> existingRes = existing != null ? this.getResourceCount(existing.getResources()) : Collections.EMPTY_MAP;
        Set<String> resources = app.getResources();
        HashSet<String> res = new HashSet<String>();
        if (resources != null) {
            int cnt;
            for (String r : resources) {
                if (add) {
                    cnt = existingRes.containsKey(r) ? existingRes.get(r) + 1 : 1;
                    res.add(cnt + "\t" + r);
                    continue;
                }
                cnt = existingRes.containsKey(r) ? existingRes.get(r) - 1 : 0;
                if (cnt <= 0) continue;
                res.add(cnt + "\t" + r);
            }
            for (String r : existingRes.keySet()) {
                if (resources.contains(r)) continue;
                cnt = existingRes.get(r);
                res.add(cnt + "\t" + r);
            }
        } else {
            for (String r : existingRes.keySet()) {
                int cnt = existingRes.get(r);
                res.add(cnt + "\t" + r);
            }
        }
        Application clone = app.clone();
        clone.setResources(res);
        return clone;
    }

    private Map<String, Set<String>> getApplicationData(Application appl, boolean add) {
        Application app = this.getStorableApplication(appl, add);
        Set<String> resources = app.getResources();
        HashMap<String, Set<String>> data = new HashMap<String, Set<String>>();
        data.put(CONFIG_APPLICATIONTYPE, this.getSet(app.getApplicationType().getName()));
        data.put(CONFIG_ACTIONS, this.getActionSet(app.getActions()));
        data.put(CONFIG_RESOURCES, resources == null ? Collections.EMPTY_SET : resources);
        data.put(CONFIG_ENTITLEMENT_COMBINER, this.getSet(app.getEntitlementCombiner().getClass().getName()));
        Set<String> conditions = app.getConditions();
        data.put(CONFIG_CONDITIONS, conditions == null ? Collections.EMPTY_SET : conditions);
        Set<String> subjects = app.getSubjects();
        data.put(CONFIG_SUBJECTS, subjects == null ? Collections.EMPTY_SET : subjects);
        ISaveIndex sIndex = app.getSaveIndex();
        String saveIndexClassName = sIndex != null ? sIndex.getClass().getName() : null;
        data.put(CONFIG_SAVE_INDEX_IMPL, saveIndexClassName == null ? Collections.EMPTY_SET : this.getSet(saveIndexClassName));
        ISearchIndex searchIndex = app.getSearchIndex();
        String searchIndexClassName = searchIndex != null ? searchIndex.getClass().getName() : null;
        data.put(CONFIG_SEARCH_INDEX_IMPL, searchIndexClassName == null ? Collections.EMPTY_SET : this.getSet(searchIndexClassName));
        ResourceName recComp = app.getResourceComparator();
        String resCompClassName = recComp != null ? recComp.getClass().getName() : null;
        data.put(CONFIG_RESOURCE_COMP_IMPL, resCompClassName == null ? Collections.EMPTY_SET : this.getSet(resCompClassName));
        Set<String> sbjAttributes = app.getAttributeNames();
        data.put(ATTR_NAME_SUBJECT_ATTR_NAMES, sbjAttributes == null ? Collections.EMPTY_SET : sbjAttributes);
        return data;
    }

    private ApplicationType createApplicationType(String name, Map<String, Set<String>> data) throws InstantiationException, IllegalAccessException {
        Map<String, Boolean> actions = this.getActions(data);
        String saveIndexImpl = this.getAttribute(data, CONFIG_SAVE_INDEX_IMPL);
        Class saveIndex = ApplicationTypeManager.getSaveIndex(saveIndexImpl);
        String searchIndexImpl = this.getAttribute(data, CONFIG_SEARCH_INDEX_IMPL);
        Class searchIndex = ApplicationTypeManager.getSearchIndex(searchIndexImpl);
        String resourceComp = this.getAttribute(data, CONFIG_RESOURCE_COMP_IMPL);
        Class resComp = ApplicationTypeManager.getResourceComparator(resourceComp);
        return new ApplicationType(name, actions, searchIndex, saveIndex, resComp);
    }

    private Application createApplication(String realm, String name, Map<String, Set<String>> data) throws InstantiationException, IllegalAccessException {
        Set<String> attributeNames;
        String resourceComp;
        Class resComp;
        String searchIndexImpl;
        Class searchIndex;
        String saveIndexImpl;
        Class saveIndex;
        Set<String> subjectClassNames;
        Set<String> resources;
        String applicationType = this.getAttribute(data, CONFIG_APPLICATIONTYPE);
        ApplicationType appType = ApplicationTypeManager.getAppplicationType(this.getAdminSubject(), applicationType);
        Application app = new Application(realm, name, appType);
        Map<String, Boolean> actions = this.getActions(data);
        if (actions != null) {
            app.setActions(actions);
        }
        if ((resources = data.get(CONFIG_RESOURCES)) != null) {
            app.setResources(resources);
        }
        String entitlementCombiner = this.getAttribute(data, CONFIG_ENTITLEMENT_COMBINER);
        Class combiner = EntitlementService.getEntitlementCombiner(entitlementCombiner);
        app.setEntitlementCombiner(combiner);
        Set<String> conditionClassNames = data.get(CONFIG_CONDITIONS);
        if (conditionClassNames != null) {
            app.setConditions(conditionClassNames);
        }
        if ((subjectClassNames = data.get(CONFIG_SUBJECTS)) != null) {
            app.setSubjects(subjectClassNames);
        }
        if ((saveIndex = ApplicationTypeManager.getSaveIndex(saveIndexImpl = this.getAttribute(data, CONFIG_SAVE_INDEX_IMPL))) != null) {
            app.setSaveIndex(saveIndex);
        }
        if ((searchIndex = ApplicationTypeManager.getSearchIndex(searchIndexImpl = this.getAttribute(data, CONFIG_SEARCH_INDEX_IMPL))) != null) {
            app.setSearchIndex(searchIndex);
        }
        if ((resComp = ApplicationTypeManager.getResourceComparator(resourceComp = this.getAttribute(data, CONFIG_RESOURCE_COMP_IMPL))) != null) {
            app.setResourceComparator(resComp);
        }
        if ((attributeNames = data.get(ATTR_NAME_SUBJECT_ATTR_NAMES)) != null) {
            app.setAttributeNames(attributeNames);
        }
        return app;
    }

    @Override
    public Set<String> getSubjectAttributeNames(String application) {
        try {
            SSOToken token = SubjectUtils.getSSOToken(this.getAdminSubject());
            if (token == null) {
                PrivilegeManager.debug.error("EntitlementService.getSubjectAttributeNames: admin sso token is absent", null);
            } else {
                ServiceConfig applConfig = this.getApplicationSubConfig(token, this.realm, application);
                if (applConfig != null) {
                    Application app = this.createApplication(this.realm, application, applConfig.getAttributes());
                    return app.getAttributeNames();
                }
            }
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributeNames", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributeNames", (Throwable)ex);
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributeNames", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributeNames", (Throwable)((Object)ex));
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> getSubjectAttributesCollectorNames() {
        try {
            SSOToken token = this.getSSOToken();
            if (token != null) {
                ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
                ServiceConfig orgConfig = mgr.getOrganizationConfig(this.realm, null);
                if (orgConfig != null) {
                    ServiceConfig conf = orgConfig.getSubConfig(CONFIG_SUBJECT_ATTRIBUTES_COLLECTORS);
                    return conf.getSubConfigNames();
                }
            } else {
                PrivilegeManager.debug.error("EntitlementService.getSubjectAttributesCollectorNames: admin sso token is absent", null);
            }
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributesCollectorNames", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributesCollectorNames", (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public Map<String, Set<String>> getSubjectAttributesCollectorConfiguration(String name) {
        try {
            SSOToken token = this.getSSOToken();
            if (token != null) {
                ServiceConfig conf;
                ServiceConfig sacConfig;
                ServiceConfigManager mgr = new ServiceConfigManager(SERVICE_NAME, token);
                ServiceConfig orgConfig = mgr.getOrganizationConfig(this.realm, null);
                if (orgConfig != null && (sacConfig = (conf = orgConfig.getSubConfig(CONFIG_SUBJECT_ATTRIBUTES_COLLECTORS)).getSubConfig(name)) != null) {
                    return sacConfig.getAttributes();
                }
            } else {
                PrivilegeManager.debug.error("EntitlementService.getSubjectAttributesCollectorConfiguration:admin sso token is absent", null);
            }
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributesCollectorConfiguration", (Throwable)ex);
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("EntitlementService.getSubjectAttributesCollectorConfiguration", (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public boolean hasEntitlementDITs() {
        try {
            new ServiceSchemaManager(SERVICE_NAME, SubjectUtils.getSSOToken(this.getAdminSubject()));
            return true;
        }
        catch (SMSException ex) {
            return false;
        }
        catch (SSOException ex) {
            return false;
        }
    }

    @Override
    public boolean migratedToEntitlementService() {
        if (!this.hasEntitlementDITs()) {
            return false;
        }
        Set<String> setMigrated = this.getConfiguration(MIGRATED_TO_ENTITLEMENT_SERVICES);
        String migrated = setMigrated != null && !setMigrated.isEmpty() ? setMigrated.iterator().next() : null;
        return migrated != null ? Boolean.parseBoolean(migrated) : false;
    }

    @Override
    public boolean xacmlPrivilegeEnabled() {
        if (!this.hasEntitlementDITs()) {
            return false;
        }
        Set<String> xacmlEnabledSet = this.getConfiguration(XACML_PRIVILEGE_ENABLED);
        String xacmlEnabled = xacmlEnabledSet != null && !xacmlEnabledSet.isEmpty() ? xacmlEnabledSet.iterator().next() : null;
        return xacmlEnabled != null ? Boolean.parseBoolean(xacmlEnabled) : false;
    }

    public static void useNewConsole(boolean flag) {
        if (EntitlementService.canSwitchToNewConsole()) {
            HashSet<String> values = new HashSet<String>();
            values.add(Boolean.toString(flag));
            EntitlementService.setConfiguration(adminToken, USE_NEW_CONSOLE, values);
        }
    }

    public static boolean canSwitchToNewConsole() {
        try {
            new ServiceSchemaManager(SERVICE_NAME, adminToken);
            Set<String> setMigrated = EntitlementService.getConfiguration(adminToken, MIGRATED_TO_ENTITLEMENT_SERVICES);
            String migrated = setMigrated != null && !setMigrated.isEmpty() ? setMigrated.iterator().next() : null;
            return migrated != null ? Boolean.parseBoolean(migrated) : false;
        }
        catch (SMSException ex) {
            return false;
        }
        catch (SSOException ex) {
            return false;
        }
    }

    public static String useNewConsole() {
        if (!EntitlementService.canSwitchToNewConsole()) {
            return "";
        }
        Set<String> values = EntitlementService.getConfiguration(adminToken, USE_NEW_CONSOLE);
        return values != null && !values.isEmpty() ? values.iterator().next() : "";
    }

    public static boolean toUseNewConsole() {
        String val = EntitlementService.useNewConsole();
        return Boolean.parseBoolean(val);
    }
}

