/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.log.util.LogFileFilter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;

public class VerifierList {
    public TreeMap getKeysAndFiles(File dir, String filter) {
        TreeMap<String, Vector> tm = new TreeMap<String, Vector>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        });
        String[] keyFiles = this.getSortedKeyFileNames(dir, "_secure.log." + filter + "*");
        for (int i = keyFiles.length - 1; i >= 0; --i) {
            Vector logFiles = null;
            if (i > 0) {
                logFiles = this.getLogFilesForKey(dir, filter, keyFiles[i], keyFiles[i - 1]);
            } else {
                logFiles = this.getLogFilesForKey(dir, filter, keyFiles[i], null);
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmmss");
                Date d = new Date();
                logFiles.addAll(this.getLogFilesForKey(dir, filter, "_secure.log." + filter + "." + sdf.format(d), keyFiles[keyFiles.length - 1]));
            }
            tm.put(keyFiles[i], logFiles);
        }
        return tm;
    }

    public String[] getSortedKeyFileNames(File dir, String basestring) {
        Object[] keyFiles = dir.list(new LogFileFilter(basestring));
        Arrays.sort(keyFiles);
        return keyFiles;
    }

    public Vector getLogFilesForKey(File dir, String log, String key1, String key2) {
        Vector<Object> logList = new Vector<Object>();
        Object[] logFiles = dir.list(new LogFileFilter("_secure." + log + "*"));
        Arrays.sort(logFiles);
        String startLog = "_secure." + key1.substring(key1.indexOf(log));
        String endLog = null;
        if (key2 != null) {
            endLog = "_secure." + key2.substring(key2.indexOf(log));
        }
        for (int i = 0; i < logFiles.length; ++i) {
            if (startLog.compareTo((String)logFiles[i]) < 0) continue;
            if (endLog == null) {
                logList.add(logFiles[i]);
                continue;
            }
            if (endLog.compareTo((String)logFiles[i]) >= 0) continue;
            logList.add(logFiles[i]);
        }
        return logList;
    }
}

